/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.sender;

import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.notify.notifier.request.LqAttachment;
import org.tiogasolutions.notify.notifier.request.LqAttachmentFailureCallback;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.notifier.request.LqResponse;
import org.tiogasolutions.notify.notifier.request.LqResponseCallback;

public class LqSenderCallbacks {
    private final List<LqResponseCallback> responseCallbacks = new ArrayList<LqResponseCallback>();
    private final List<LqResponseCallback> successCallbacks = new ArrayList<LqResponseCallback>();
    private final List<LqResponseCallback> failureCallbacks = new ArrayList<LqResponseCallback>();
    private final List<LqAttachmentFailureCallback> attachmentFailureCallbacks = new ArrayList<LqAttachmentFailureCallback>();

    public void onResponse(LqResponseCallback callback) {
        this.responseCallbacks.add(callback);
    }

    public void onSuccess(LqResponseCallback callback) {
        this.successCallbacks.add(callback);
    }

    public void onFailure(LqResponseCallback callback) {
        this.failureCallbacks.add(callback);
    }

    public void onFailure(LqAttachmentFailureCallback callback) {
        this.attachmentFailureCallbacks.add(callback);
    }

    public void callResponse(LqResponse response) {
        this.responseCallbacks.stream().forEachOrdered(c -> c.call(response));
    }

    public void callSuccess(LqResponse response) {
        this.successCallbacks.stream().forEachOrdered(c -> c.call(response));
        this.callResponse(response);
    }

    public void callFailure(LqResponse response) {
        this.failureCallbacks.stream().forEachOrdered(c -> c.call(response));
    }

    public void callFailure(LqRequest request, LqAttachment attachment, Throwable t) {
        this.attachmentFailureCallbacks.stream().forEachOrdered(c -> c.call(request, attachment, t));
    }
}

