/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.sender;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.json.LqRequestJsonBuilder;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.notifier.request.LqRequestStatus;
import org.tiogasolutions.notify.notifier.request.LqResponse;
import org.tiogasolutions.notify.notifier.sender.LqAbstractSender;

public class LqSimpleSender
extends LqAbstractSender {
    private static final Logger log = LoggerFactory.getLogger(LqSimpleSender.class);
    private LqRequest lastRequest;

    @Override
    public Future<LqResponse> send(LqRequest request) {
        this.lastRequest = request;
        if (log.isTraceEnabled()) {
            log.trace(new LqRequestJsonBuilder().toJson(request, LqRequestStatus.READY));
        } else {
            log.debug("Notification {}:{}", (Object)this.lastRequest.getTopic(), (Object)this.lastRequest.getSummary());
        }
        LqResponse response = LqResponse.newSuccess(request);
        this.callbacks.callSuccess(response);
        return CompletableFuture.completedFuture(response);
    }

    public LqRequest getLastRequest() {
        return this.lastRequest;
    }

    public void clearLast() {
        this.lastRequest = null;
    }
}

