/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.json;

import java.util.Iterator;
import java.util.Map;
import org.tiogasolutions.notify.notifier.request.LqExceptionInfo;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.notifier.request.LqRequestStatus;

public class LqRequestJsonBuilder {
    private final StringBuilder sb = new StringBuilder();
    private String indent = "";
    private LqRequestStatus status;

    public String toJson(LqRequest request, LqRequestStatus status) {
        this.beginObject();
        if (status == null) {
            this.firstField("topic", request.getTopic());
        } else {
            this.firstField("requestStatus", status.name());
            this.field("topic", request.getTopic());
        }
        this.field("summary", request.getSummary());
        this.field("trackingId", request.getTrackingId());
        this.field("createdAt", request.getCreatedAt().toString());
        this.traits(request.getTraitMap());
        if (request.getExceptionInfo() != null) {
            this.exceptionInfo(true, request.getExceptionInfo());
        }
        this.endObject();
        return this.sb.toString();
    }

    protected void traits(Map<String, String> traitMap) {
        Map.Entry<String, String> entry;
        this.sb.append(String.format(",%n%s\"traitMap\" : ", this.indent));
        this.beginObject();
        Iterator<Map.Entry<String, String>> it = traitMap.entrySet().iterator();
        if (it.hasNext()) {
            entry = it.next();
            this.firstField(entry.getKey(), entry.getValue());
        }
        while (it.hasNext()) {
            entry = it.next();
            this.field(entry.getKey(), entry.getValue());
        }
        this.endObject();
    }

    protected void exceptionInfo(boolean first, LqExceptionInfo exInfo) {
        if (first) {
            this.sb.append(String.format(",%n%s\"exceptionInfo\" : ", this.indent));
        } else {
            this.sb.append(String.format(",%n%s\"cause\" : ", this.indent));
        }
        this.beginObject();
        this.firstField("exceptionType", exInfo.getExceptionType());
        this.field("message", exInfo.getMessage());
        String stackTrace = exInfo.getStackTrace().replace("\t", "\\t").replace("\n", "\\n");
        this.field("stackTrace", stackTrace);
        if (exInfo.getCause() == null) {
            this.sb.append(String.format(",%n%s\"cause\" : null", this.indent));
        } else {
            this.exceptionInfo(false, exInfo.getCause());
        }
        this.endObject();
    }

    protected void beginObject() {
        this.sb.append(String.format("{%n", new Object[0]));
        this.indent = this.indent + "  ";
    }

    protected void endObject() {
        this.indent = this.indent.substring(2);
        this.sb.append(String.format("%n%s}", this.indent));
    }

    protected void firstField(String key, String value) {
        if (value == null) {
            this.sb.append(String.format("%s\"%s\" : null", this.indent, key));
        } else {
            this.sb.append(String.format("%s\"%s\" : \"%s\"", this.indent, key, value));
        }
    }

    protected void field(String key, String value) {
        if (value == null) {
            this.sb.append(String.format(",%n%s\"%s\" : null", this.indent, key));
        } else {
            this.sb.append(String.format(",%n%s\"%s\" : \"%s\"", this.indent, key, value));
        }
    }

    protected void field(String key, int value) {
        this.sb.append(String.format(",%n%s\"%s\" : %d", this.indent, key, value));
    }
}

