/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.request;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.notifier.request.NotificationAttachment;
import org.tiogasolutions.notify.notifier.request.NotificationExceptionInfo;
import org.tiogasolutions.notify.notifier.request.NotificationLink;

public final class NotificationRequest {
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final List<NotificationLink> links;
    private final NotificationExceptionInfo exceptionInfo;
    private final List<NotificationAttachment> attachments;

    public NotificationRequest(String topic, String summary, String trackingId, ZonedDateTime createdAt, Map<String, String> traitsArg, List<NotificationLink> linksArg, NotificationExceptionInfo exceptionInfo, Collection<NotificationAttachment> attachmentsArg) {
        this.topic = topic != null ? topic : "none";
        this.summary = summary != null ? summary : "none";
        this.trackingId = trackingId;
        this.exceptionInfo = exceptionInfo;
        this.createdAt = createdAt != null ? createdAt : ZonedDateTime.now();
        LinkedHashMap<String, String> traitMap = new LinkedHashMap<String, String>();
        if (traitsArg != null) {
            traitMap.putAll(traitsArg);
        }
        this.traitMap = Collections.unmodifiableMap(traitMap);
        ArrayList<NotificationLink> linksList = new ArrayList<NotificationLink>();
        if (linksArg != null) {
            linksList.addAll(linksArg);
        }
        this.links = Collections.unmodifiableList(linksList);
        ArrayList<NotificationAttachment> attachmentsList = new ArrayList<NotificationAttachment>();
        if (attachmentsArg != null) {
            attachmentsList.addAll(attachmentsArg);
        }
        this.attachments = Collections.unmodifiableList(attachmentsList);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getSummary() {
        return this.summary;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public List<NotificationLink> getLinks() {
        return this.links;
    }

    public NotificationExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<NotificationAttachment> getAttachments() {
        return this.attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRequest that = (NotificationRequest)o;
        if (this.attachments != null ? !this.attachments.equals(that.attachments) : that.attachments != null) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals(that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.trackingId != null ? !this.trackingId.equals(that.trackingId) : that.trackingId != null) {
            return false;
        }
        return !(this.traitMap != null ? !this.traitMap.equals(that.traitMap) : that.traitMap != null);
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.trackingId != null ? this.trackingId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.traitMap != null ? this.traitMap.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        result = 31 * result + (this.attachments != null ? this.attachments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NotificationRequest{topic='" + this.topic + '\'' + ", summary='" + this.summary + '\'' + ", trackingId='" + this.trackingId + '\'' + ", createdAt=" + this.createdAt + ", traitMap=" + this.traitMap + ", links=" + this.links + ", exceptionInfo=" + this.exceptionInfo + ", attachments=" + this.attachments + '}';
    }

    public static enum Status {
        SENDING,
        READY,
        PROCESSING,
        FAILED,
        COMPLETED;

    }
}

