/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.sender;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.json.NotificationRequestJsonBuilder;
import org.tiogasolutions.notify.notifier.request.NotificationRequest;
import org.tiogasolutions.notify.notifier.request.NotificationResponse;
import org.tiogasolutions.notify.notifier.sender.AbstractNotificationSender;

public class LoggingNotificationSender
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(LoggingNotificationSender.class);
    private NotificationRequest lastRequest;

    @Override
    public Future<NotificationResponse> send(NotificationRequest request) {
        this.lastRequest = request;
        if (log.isTraceEnabled()) {
            log.trace(new NotificationRequestJsonBuilder().toJson(request, NotificationRequest.Status.READY));
        } else {
            log.debug("Notification {}:{}", (Object)this.lastRequest.getTopic(), (Object)this.lastRequest.getSummary());
        }
        NotificationResponse response = NotificationResponse.newSuccess(request);
        this.callbacks.callSuccess(response);
        return CompletableFuture.completedFuture(response);
    }

    public NotificationRequest getLastRequest() {
        return this.lastRequest;
    }

    public void clearLast() {
        this.lastRequest = null;
    }
}

