/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.send;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public final class NotificationAttachment {
    private final String name;
    private final String contentType;
    private final InputStream inputStream;

    public NotificationAttachment(String name, String contentType, InputStream inputStream) {
        this.name = name != null ? name : "no name";
        this.contentType = contentType != null ? contentType : "unknown";
        this.inputStream = inputStream;
    }

    public NotificationAttachment(String name, String contentType, byte[] content) {
        this(name, contentType, new ByteArrayInputStream(content));
    }

    public NotificationAttachment(String name, String contentType, String content) {
        this(name, contentType, (content != null ? content : "").getBytes(StandardCharsets.UTF_8));
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void dispose() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationAttachment that = (NotificationAttachment)o;
        if (!this.contentType.equals(that.contentType)) {
            return false;
        }
        if (this.inputStream != null ? !this.inputStream.equals(that.inputStream) : that.inputStream != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.contentType.hashCode();
        result = 31 * result + (this.inputStream != null ? this.inputStream.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NotificationRequestAttachment{name='" + this.name + '\'' + ", contentType='" + this.contentType + '\'' + '}';
    }
}

