/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.send;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.notifier.send.NotificationExceptionInfo;
import org.tiogasolutions.notify.notifier.send.NotificationLink;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequest;

public class SendNotificationRequestJsonBuilder {
    private final StringBuilder sb = new StringBuilder();
    private String indent = "";
    private boolean firstElement;

    public String toJson(SendNotificationRequest request, SendNotificationRequest.Status status) {
        this.beginObject();
        if (status == null) {
            this.firstField("topic", request.getTopic());
        } else {
            this.firstField("requestStatus", status.name());
            this.field("topic", request.getTopic());
        }
        this.field("summary", request.getSummary());
        this.field("trackingId", request.getTrackingId());
        this.field("createdAt", request.getCreatedAt().toString());
        this.traits(request.getTraitMap());
        this.links(request.getLinks());
        if (request.getExceptionInfo() != null) {
            this.exceptionInfo(true, request.getExceptionInfo());
        }
        this.endObject();
        return this.sb.toString();
    }

    protected void traits(Map<String, String> traitMap) {
        Map.Entry<String, String> entry;
        this.comma();
        this.newLine();
        this.indent();
        this.attr("traitMap");
        this.beginObject();
        Iterator<Map.Entry<String, String>> it = traitMap.entrySet().iterator();
        if (it.hasNext()) {
            entry = it.next();
            this.firstField(entry.getKey(), entry.getValue());
        }
        while (it.hasNext()) {
            entry = it.next();
            this.field(entry.getKey(), entry.getValue());
        }
        this.endObject();
    }

    protected void links(List<NotificationLink> links) {
        this.comma();
        this.newLine();
        this.indent();
        this.attr("links");
        this.beginArray();
        for (NotificationLink link : links) {
            this.nextElement();
            this.beginObject();
            this.firstField("name", link.getName());
            this.field("href", link.getHref());
            this.endObject();
        }
        this.endArray();
    }

    protected void exceptionInfo(boolean first, NotificationExceptionInfo exInfo) {
        this.comma();
        this.newLine();
        this.indent();
        this.attr(first ? "exceptionInfo" : "cause");
        this.beginObject();
        this.firstField("exceptionType", exInfo.getExceptionType());
        this.field("message", exInfo.getMessage());
        this.field("stackTrace", exInfo.getStackTrace());
        if (exInfo.getCause() == null) {
            this.comma();
            this.newLine();
            this.indent();
            this.attr("cause");
            this.value(null);
        } else {
            this.exceptionInfo(false, exInfo.getCause());
        }
        this.endObject();
    }

    protected void beginObject() {
        this.append("{");
        this.newLine();
        this.indent = this.indent + "  ";
    }

    protected void endObject() {
        this.indent = this.indent.substring(2);
        this.newLine();
        this.indent();
        this.append("}");
    }

    protected void beginArray() {
        this.indent = this.indent + "  ";
        this.append("[");
        this.newLine();
        this.indent();
        this.firstElement = true;
    }

    protected void nextElement() {
        if (!this.firstElement) {
            this.comma();
            this.newLine();
            this.indent();
        }
        this.firstElement = false;
    }

    protected void endArray() {
        this.indent = this.indent.substring(2);
        this.newLine();
        this.indent();
        this.append("]");
        this.firstElement = false;
    }

    protected void firstField(String key, String value) {
        this.indent();
        this.attr(key);
        this.value(value);
    }

    protected void field(String key, String value) {
        this.comma();
        this.newLine();
        this.indent();
        this.attr(key);
        this.value(value);
    }

    protected void attr(String key) {
        this.quote();
        this.append(key);
        this.quote();
        this.fieldSep();
    }

    protected void value(Object object) {
        if (object == null || object instanceof Number) {
            this.append(object);
        } else {
            String cleaned = object.toString().replace("\t", "\\t").replace("\n", "\\n").replace("\r", "");
            this.quote();
            this.append(cleaned);
            this.quote();
        }
    }

    private void fieldSep() {
        this.sb.append(" : ");
    }

    protected void quote() {
        this.sb.append("\"");
    }

    private void comma() {
        this.append(",");
    }

    protected void indent() {
        this.sb.append(this.indent);
    }

    protected void newLine() {
        this.sb.append("\n");
    }

    protected void append(Object object) {
        if (object == null) {
            this.sb.append("null");
        } else {
            this.sb.append(object.toString());
        }
    }

    protected void append(Number number) {
        this.sb.append(number == null ? null : number.toString());
    }
}

