/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.push;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.UnsupportedMethodException;
import org.tiogasolutions.notify.kernel.processor.HtmlMessage;
import org.tiogasolutions.notify.kernel.processor.ProcessorType;
import org.tiogasolutions.notify.kernel.processor.TaskProcessor;
import org.tiogasolutions.notify.kernel.processor.ThymeleafMessageBuilder;
import org.tiogasolutions.notify.processor.push.PushConfig;
import org.tiogasolutions.notify.processor.push.PushDestinationType;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.Task;
import org.tiogasolutions.notify.pub.TaskResponse;
import org.tiogasolutions.notify.pub.route.ArgValue;
import org.tiogasolutions.notify.pub.route.ArgValueMap;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.push.gateway.CosmicPushGateway;
import org.tiogasolutions.push.pub.EmailPush;
import org.tiogasolutions.push.pub.TwilioSmsPush;
import org.tiogasolutions.push.pub.XmppPush;
import org.tiogasolutions.push.pub.common.Push;

public class PushTaskProcessor
implements TaskProcessor {
    private static final Logger log = LoggerFactory.getLogger(PushTaskProcessor.class);
    private static final ProcessorType PROCESSOR_TYPE = new ProcessorType("push");
    private final ThymeleafMessageBuilder messageBuilder = new ThymeleafMessageBuilder();
    CosmicPushGateway gateway;
    private PushConfig pushConfig;

    public void init(BeanFactory beanFactory) {
        this.pushConfig = (PushConfig)beanFactory.getBean(PushConfig.class);
        this.gateway = (CosmicPushGateway)beanFactory.getBean(CosmicPushGateway.class);
    }

    public ProcessorType getType() {
        return PROCESSOR_TYPE;
    }

    public boolean isReady() {
        try {
            this.gateway.ping();
            return true;
        }
        catch (Exception e) {
            log.warn("The push-server is not responding to a ping.");
            return false;
        }
    }

    public TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        List<Push> pushList;
        if (this.gateway == null) {
            return TaskResponse.retry((String)"Push gateway was not yet set.");
        }
        log.debug("Processing task: " + task);
        Destination destination = task.getDestination();
        ArgValueMap argMap = destination.getArgValueMap();
        if (!argMap.hasArg("type")) {
            throw ApiException.badRequest((String)"Task given to push processor which does not have a type.", (String[])new String[0]);
        }
        List<String> recipients = this.readRecipients(argMap);
        if (recipients.isEmpty()) {
            throw ApiException.badRequest((String)"Task given to push processor which does not have any recipients.", (String[])new String[0]);
        }
        PushDestinationType destinationType = PushDestinationType.valueOf(argMap.asString("type"));
        if (destinationType.isSmsMsg()) {
            pushList = this.toSmsPush(notification, recipients);
        } else if (destinationType.isJabberMsg()) {
            pushList = this.toJabber(notification, recipients);
        } else if (destinationType.isEmailMsg()) {
            pushList = this.toEmailPush(domainProfile, notification, task, argMap, recipients);
        } else if (destinationType.isPhoneCall()) {
            pushList = this.toPhoneCallPush();
        } else {
            String msg = String.format("The task type \"%s\" is not supported.", new Object[]{destinationType});
            throw new UnsupportedOperationException(msg);
        }
        pushList.forEach(arg_0 -> ((CosmicPushGateway)this.gateway).send(arg_0));
        return TaskResponse.complete((String)"Ok");
    }

    private List<String> readRecipients(ArgValueMap argMap) {
        ArgValue argValue;
        ArrayList<String> recipients = new ArrayList<String>();
        if (argMap.hasArg("recipient")) {
            argValue = argMap.asValue("recipient");
            if (argValue.getArgType() == ArgValue.ArgType.STRING) {
                recipients.add(argValue.asString());
            }
            if (argValue.getArgType() == ArgValue.ArgType.LIST) {
                recipients.addAll(argValue.asList().stream().map(ArgValue::asString).collect(Collectors.toList()));
            }
        }
        if (argMap.hasArg("recipients")) {
            argValue = argMap.asValue("recipients");
            if (argValue.getArgType() == ArgValue.ArgType.STRING) {
                recipients.add(argValue.asString());
            }
            if (argValue.getArgType() == ArgValue.ArgType.LIST) {
                recipients.addAll(argValue.asList().stream().map(ArgValue::asString).collect(Collectors.toList()));
            }
        }
        return recipients;
    }

    private List<Push> toJabber(Notification notification, List<String> recipients) {
        return recipients.stream().map(recipient -> XmppPush.newPush((String)recipient, (String)notification.getSummary(), null, (String[])new String[0])).collect(Collectors.toList());
    }

    private List<Push> toSmsPush(Notification notification, List<String> recipients) {
        return recipients.stream().map(recipient -> TwilioSmsPush.newPush((String)this.pushConfig.getSmsFromNumber(), (String)recipient, (String)notification.getSummary(), null, (String[])new String[0])).collect(Collectors.toList());
    }

    private List<Push> toPhoneCallPush() {
        throw new UnsupportedMethodException();
    }

    private List<Push> toEmailPush(DomainProfile domainProfile, Notification notification, Task task, ArgValueMap argMap, List<String> recipients) {
        String templatePath = this.messageBuilder.getEmailTemplatePath(argMap, "templatePath");
        HtmlMessage message = this.messageBuilder.createHtmlMessage(domainProfile, notification, task, templatePath);
        return recipients.stream().map(recipient -> EmailPush.newPush((String)recipient, (String)this.pushConfig.getEmailFromAddress(), (String)message.getSubject(), (String)message.getBody(), null, (String[])new String[0])).collect(Collectors.toList());
    }
}

