/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.slack;

import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.notify.kernel.message.ThymeleafMessageBuilder;
import org.tiogasolutions.notify.kernel.task.TaskProcessor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorType;
import org.tiogasolutions.notify.processor.slack.SlackMessage;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.task.Task;
import org.tiogasolutions.notify.pub.task.TaskResponse;

@Component
public class SlackTaskProcessor
implements TaskProcessor {
    public static final String DEFAULT_TEMPLATE_PATH = "classpath:/notify-processor-slack/default-slack-template.html";
    private final JsonTranslator jsonTranslator;
    private final ThymeleafMessageBuilder messageBuilder;
    private static final TaskProcessorType PROVIDER_TYPE = new TaskProcessorType("slack");
    private static final Logger log = LoggerFactory.getLogger(SlackTaskProcessor.class);
    private final Client client;

    @Autowired
    public SlackTaskProcessor(JsonTranslator jsonTranslator) {
        this.jsonTranslator = jsonTranslator;
        this.messageBuilder = new ThymeleafMessageBuilder();
        ClientConfig httpClientConfig = new ClientConfig().register(MultiPartFeature.class);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)httpClientConfig);
        this.client = clientBuilder.build();
    }

    public boolean isReady() {
        return true;
    }

    public TaskProcessorType getType() {
        return PROVIDER_TYPE;
    }

    public TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        try {
            Map valueMap = task.getDestination().getArguments();
            if (!valueMap.containsKey("slackUrl")) {
                throw ApiException.badRequest((String)"Slack destination does not define a slackUrl argument", (String[])new String[0]);
            }
            String slackUrl = (String)valueMap.get("slackUrl");
            String templatePath = this.messageBuilder.getTemplatePath(valueMap, "templatePath", DEFAULT_TEMPLATE_PATH);
            String messageText = this.messageBuilder.createMessage(domainProfile, notification, task, templatePath);
            SlackMessage message = new SlackMessage().setText(messageText);
            if (valueMap.containsKey("channel")) {
                message.setChannel((String)valueMap.get("channel"));
            }
            if (valueMap.containsKey("username")) {
                message.setUsername((String)valueMap.get("username"));
            }
            if (valueMap.containsKey("iconEmoji")) {
                message.setIconEmoji((String)valueMap.get("iconEmoji"));
            }
            if (valueMap.containsKey("iconUrl")) {
                message.setIconUrl((String)valueMap.get("iconUrl"));
            }
            String json = this.jsonTranslator.toJson((Object)message);
            Entity entity = Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE);
            Response response = this.client.target(slackUrl).request().post(entity);
            if (response.getStatus() == 200 || response.getStatus() == 201) {
                log.debug("Successfully sent Slack message: {}", (Object)notification.getSummary());
                return TaskResponse.complete((String)"Ok");
            }
            String content = (String)response.readEntity(String.class);
            String msg = String.format("Failure sending Slack message [%s]: %s", response.getStatus(), content);
            log.error(msg);
            log.error("Slack message JSON: " + json);
            return TaskResponse.fail((String)msg);
        }
        catch (Throwable t) {
            log.error("Exception sending Slack message.", t);
            return TaskResponse.fail((String)"Exception sending Slack message.", (Throwable)t);
        }
    }
}

