/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.route;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.pub.route.ArgValue;

public class ArgValueMap
implements Iterable<Map.Entry<String, ArgValue>> {
    private final Map<String, ArgValue> argMap;

    @JsonCreator
    public ArgValueMap(@JsonProperty(value="argMap") Map<String, ?> givenMap) {
        HashMap<String, ArgValue> map = new HashMap<String, ArgValue>();
        if (givenMap != null) {
            for (Map.Entry<String, ?> entry : givenMap.entrySet()) {
                map.put(entry.getKey(), new ArgValue(entry.getValue()));
            }
        }
        this.argMap = Collections.unmodifiableMap(map);
    }

    public boolean isArg(String name, Object other) {
        if (this.argMap.containsKey(name)) {
            ArgValue value = this.argMap.get(name);
            return value.isEqual(other);
        }
        return false;
    }

    public Object get(String name) {
        ArgValue value = this.argMap.get(name);
        if (value == null || value.getValue() == null) {
            return null;
        }
        if (value.getValue() instanceof ArgValueMap) {
            return value.asMap();
        }
        return value.getValue();
    }

    public Map<String, ArgValue> getArgMap() {
        return this.argMap;
    }

    public boolean hasArg(String name) {
        return this.argMap.containsKey(name);
    }

    public ArgValue asValue(String name) {
        return this.argMap.get(name);
    }

    public String asString(String name) {
        return this.argMap.get(name) == null ? null : this.argMap.get(name).asString();
    }

    public Boolean asBoolean(String name) {
        return this.argMap.get(name) == null ? null : this.argMap.get(name).asBoolean();
    }

    public Number asNumber(String name) {
        return this.argMap.get(name) == null ? (Number)null : (Number)this.argMap.get(name).asNumber();
    }

    public List<ArgValue> asList(String name) {
        return this.argMap.get(name) == null ? null : this.argMap.get(name).asList();
    }

    public Map<String, ArgValue> asMap(String name) {
        return this.argMap.get(name) == null ? null : this.argMap.get(name).asMap();
    }

    public <T> T asEnum(Class<T> type, String name) {
        return this.argMap.get(name) == null ? null : (T)this.argMap.get(name).asEnum(type);
    }

    @Override
    public Iterator<Map.Entry<String, ArgValue>> iterator() {
        return this.argMap.entrySet().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgValueMap that = (ArgValueMap)o;
        return !(this.argMap != null ? !this.argMap.equals(that.argMap) : that.argMap != null);
    }

    public int hashCode() {
        return this.argMap != null ? this.argMap.hashCode() : 0;
    }

    public String toString() {
        return "ArgValueMap{argMap=" + this.argMap + '}';
    }
}

