/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.http;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.LqException;
import org.tiogasolutions.notify.notifier.json.LqRequestJsonBuilder;
import org.tiogasolutions.notify.notifier.request.LqAttachment;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.notifier.request.LqRequestStatus;
import org.tiogasolutions.notify.notifier.request.LqResponse;
import org.tiogasolutions.notify.notifier.sender.LqAbstractSender;
import org.tiogasolutions.notify.sender.http.LqHttpSenderConfig;

public class LqHttpSender
extends LqAbstractSender {
    private static final Logger log = LoggerFactory.getLogger(LqHttpSender.class);
    private final ExecutorService executorService;
    private final Client client;
    private final String baseUrl;

    public LqHttpSender(LqHttpSenderConfig config) {
        ClientConfig httpClientConfig = new ClientConfig().register(MultiPartFeature.class);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)httpClientConfig);
        if (config.getSslConfig() != null) {
            clientBuilder.sslContext(config.getSslConfig().getSSLContext());
        }
        this.client = clientBuilder.build();
        HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)config.getUserName(), (String)config.getPassword());
        this.client.register((Object)feature);
        this.baseUrl = config.getUrl();
        this.executorService = Executors.newSingleThreadExecutor();
        log.info("Configured LqHttpSender for " + this.baseUrl);
    }

    public Future<LqResponse> send(LqRequest request) {
        Callable<LqResponse> callable = () -> {
            Response sendResponse;
            try {
                sendResponse = this.sendRequest(request, LqRequestStatus.SENDING);
            }
            catch (Exception t) {
                LqResponse lqResponse = LqResponse.newFailure((LqRequest)request, (Throwable)t);
                this.callbacks.callFailure(lqResponse);
                log.error("Failure sending Lq notification request: ", (Throwable)t);
                return lqResponse;
            }
            int status = sendResponse.getStatus();
            if (status == 200 || status == 201) {
                Link attachmentLink = sendResponse.getLink("attachments");
                for (LqAttachment attachment : request.getAttachments()) {
                    try {
                        this.sendAttachment(request, attachment, attachmentLink);
                    }
                    catch (Throwable t) {
                        this.callbacks.callFailure(request, attachment, t);
                        log.error("Failure sending Lq notification attachments: ", t);
                        return LqResponse.newFailure((LqRequest)request, (Throwable)t);
                    }
                }
                LqResponse lqResponse = LqResponse.newSuccess((LqRequest)request);
                this.callbacks.callSuccess(lqResponse);
                return lqResponse;
            }
            LqException ex = new LqException("Non successful response from send: " + sendResponse.getStatus());
            LqResponse lqResponse = LqResponse.newFailure((LqRequest)request, (Throwable)ex);
            this.callbacks.callFailure(lqResponse);
            return lqResponse;
        };
        return this.executorService.submit(callable);
    }

    public void dispose() {
        this.executorService.shutdown();
    }

    protected Response sendRequest(LqRequest request, LqRequestStatus status) {
        String json = new LqRequestJsonBuilder().toJson(request, status);
        Entity entity = Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        WebTarget webTarget = this.client.target(this.baseUrl);
        return webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)MediaType.APPLICATION_JSON_TYPE).put(entity);
    }

    protected void sendAttachment(LqRequest request, LqAttachment attachment, Link attachmentLink) {
        StreamDataBodyPart streamPart = new StreamDataBodyPart(attachment.getName(), attachment.getInputStream(), attachment.getContentType());
        WebTarget webTarget = this.client.target(attachmentLink).path(attachment.getName());
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)streamPart);
        Response response = webTarget.request().post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            String msg = String.format("Failure sending attachment %s", response.getStatusInfo().getReasonPhrase());
            this.callbacks.callFailure(request, attachment, (Throwable)new LqException(msg));
            log.error(msg);
        }
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected Client getClient() {
        return this.client;
    }

    protected String getBaseUrl() {
        return this.baseUrl;
    }
}

