/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.http;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.LqException;
import org.tiogasolutions.notify.notifier.json.LqRequestJsonBuilder;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.notifier.request.LqRequestStatus;
import org.tiogasolutions.notify.notifier.request.LqResponse;
import org.tiogasolutions.notify.sender.http.LqHttpSender;
import org.tiogasolutions.notify.sender.http.LqHttpSenderConfig;

public class LqSimpleHttpSender
extends LqHttpSender {
    private static final Logger log = LoggerFactory.getLogger(LqSimpleHttpSender.class);

    public LqSimpleHttpSender(LqHttpSenderConfig config) {
        super(config);
        log.info("Configured SimpleLqHttpSender for " + this.getBaseUrl());
    }

    @Override
    public Future<LqResponse> send(LqRequest request) {
        Callable<LqResponse> callable = () -> {
            Response sendResponse;
            try {
                sendResponse = this.sendRequest(request, LqRequestStatus.READY);
            }
            catch (Exception t) {
                LqResponse lqResponse = LqResponse.newFailure((LqRequest)request, (Throwable)t);
                this.callbacks.callFailure(lqResponse);
                log.error("Failure sending Lq notification request: ", (Throwable)t);
                return lqResponse;
            }
            int status = sendResponse.getStatus();
            if (status == 200 || status == 201) {
                LqResponse lqResponse = LqResponse.newSuccess((LqRequest)request);
                this.callbacks.callSuccess(lqResponse);
                return lqResponse;
            }
            LqException ex = new LqException("Non successful response from send: " + sendResponse.getStatus());
            LqResponse lqResponse = LqResponse.newFailure((LqRequest)request, (Throwable)ex);
            this.callbacks.callFailure(lqResponse);
            return lqResponse;
        };
        return this.getExecutorService().submit(callable);
    }

    @Override
    protected Response sendRequest(LqRequest request, LqRequestStatus status) {
        String json = new LqRequestJsonBuilder().toJson(request, status);
        Entity entity = Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        WebTarget webTarget = this.getClient().target(this.getBaseUrl());
        return webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)MediaType.APPLICATION_JSON_TYPE).post(entity);
    }
}

