/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.tiogasolutions.notify.notifier.Notifier;
import org.tiogasolutions.notify.sender.lambda.LambdaSnsNotifier;
import org.tiogasolutions.notify.sender.lambda.Logger;
import org.tiogasolutions.notify.sender.lambda.build.CodeBuildStateChangeMsg;
import org.tiogasolutions.notify.sender.lambda.build.Detail;
import org.tiogasolutions.notify.sender.lambda.sns.SnsRecord;

public class LambdaNotifierCodeBuildStateChange
extends LambdaSnsNotifier {
    @Override
    public LambdaSnsNotifier.Processor createProcessor(ObjectMapper om, Logger logger, Notifier notifier, Context context, SnsRecord record) {
        return new CodeBuildProcessor(om, logger, notifier, context, record, "Build Status");
    }

    public class CodeBuildProcessor
    extends LambdaSnsNotifier.Processor {
        private CodeBuildStateChangeMsg codeBuildStateChangeMsg;

        public CodeBuildProcessor(ObjectMapper om, Logger logger, Notifier notifier, Context context, SnsRecord record, String topicName) {
            super(LambdaNotifierCodeBuildStateChange.this, om, logger, notifier, context, record, topicName);
        }

        @Override
        protected void processPayload() throws Exception {
            String json = this.record.getSns().getMessage();
            this.codeBuildStateChangeMsg = (CodeBuildStateChangeMsg)this.om.readValue(json, CodeBuildStateChangeMsg.class);
        }

        @Override
        protected void decorateNotification() {
            Detail detail = this.codeBuildStateChangeMsg.getDetail();
            this.builder.trait("version", (Object)this.codeBuildStateChangeMsg.getVersion());
            this.builder.trait("id", (Object)this.codeBuildStateChangeMsg.getId());
            this.builder.trait("detail_type", (Object)this.codeBuildStateChangeMsg.getDetailType());
            this.builder.trait("source", (Object)this.codeBuildStateChangeMsg.getSource());
            this.builder.trait("account", (Object)this.codeBuildStateChangeMsg.getAccount());
            this.builder.trait("time", (Object)this.codeBuildStateChangeMsg.getTime());
            this.builder.trait("region", (Object)this.codeBuildStateChangeMsg.getRegion());
            for (int i = 0; i < this.codeBuildStateChangeMsg.getResources().size(); ++i) {
                String resource = this.codeBuildStateChangeMsg.getResources().get(i);
                this.builder.trait("resources-" + i, (Object)resource);
            }
            String status = detail.getBuildStatus();
            this.builder.trait("build_status", (Object)status);
            String project = detail.getProjectName();
            this.builder.trait("project_name", (Object)project);
            this.builder.trait("build_id", (Object)detail.getBuildId());
            this.builder.trait("current_phase", (Object)detail.getCurrentPhase());
            this.builder.trait("current_phase_context", (Object)detail.getCurrentPhaseContext());
            this.builder.trait("detail_version", (Object)detail.getVersion());
            this.summary = "IN_PROGRESS".equals(status) ? String.format("The build for %s has started.", project, status) : ("FAILED".equals(status) ? String.format("The build of %s has failed.", project, status) : ("SUCCEEDED".equals(status) ? String.format("The build of %s has succeeded.", project, status) : String.format("Build status for %s is %s.", project, status)));
        }
    }
}

