/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.notify.notifier.Notifier;
import org.tiogasolutions.notify.sender.lambda.LambdaSnsNotifier;
import org.tiogasolutions.notify.sender.lambda.Logger;
import org.tiogasolutions.notify.sender.lambda.pipeline.CodePipelineApprovalMsg;
import org.tiogasolutions.notify.sender.lambda.sns.SnsRecord;

public class LambdaNotifierCodePipelineApproval
extends LambdaSnsNotifier {
    @Override
    public LambdaSnsNotifier.Processor createProcessor(ObjectMapper om, Logger logger, Notifier notifier, Context context, SnsRecord record) {
        return new PipelineProcessor(om, logger, notifier, context, record, "AWS CodePipeline Approval");
    }

    public class PipelineProcessor
    extends LambdaSnsNotifier.Processor {
        private CodePipelineApprovalMsg codePipelineApprovalMsg;

        public PipelineProcessor(ObjectMapper om, Logger logger, Notifier notifier, Context context, SnsRecord record, String topicName) {
            super(LambdaNotifierCodePipelineApproval.this, om, logger, notifier, context, record, topicName);
        }

        @Override
        protected void processPayload() throws Exception {
            String json = this.record.getSns().getMessage();
            this.codePipelineApprovalMsg = (CodePipelineApprovalMsg)this.om.readValue(json, CodePipelineApprovalMsg.class);
        }

        @Override
        protected void decorateNotification() {
            CodePipelineApprovalMsg.Approval approval = this.codePipelineApprovalMsg.getApproval();
            this.builder.trait("region", (Object)this.codePipelineApprovalMsg.getRegion());
            this.builder.trait("consoleLink", (Object)this.codePipelineApprovalMsg.getConsoleLink());
            this.builder.trait("pipelineName", (Object)approval.getPipelineName());
            this.builder.trait("stageName", (Object)approval.getStageName());
            this.builder.trait("actionName", (Object)approval.getActionName());
            this.builder.trait("token", (Object)approval.getToken());
            this.builder.trait("expires", (Object)approval.getExpires());
            this.builder.trait("externalEntityLink", (Object)approval.getExternalEntityLink());
            this.builder.trait("customData", (Object)approval.getCustomData());
            this.summary = String.format("Approval to <%s|%s> is required for the pipeline %s.", this.codePipelineApprovalMsg.getConsoleLink(), approval.getActionName().toLowerCase().replace("-", " "), approval.getPipelineName());
            if (StringUtils.isNotBlank((Object)approval.getCustomData())) {
                this.summary = this.summary + String.format("\n%s", approval.getCustomData());
            }
            if (StringUtils.isNotBlank((Object)approval.getCustomData())) {
                this.summary = this.summary + String.format("\nSee also <%s>", approval.getExternalEntityLink());
            }
        }
    }
}

