/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.tiogasolutions.notify.notifier.Notifier;
import org.tiogasolutions.notify.sender.lambda.LambdaSnsNotifier;
import org.tiogasolutions.notify.sender.lambda.Logger;
import org.tiogasolutions.notify.sender.lambda.sns.SnsRecord;

public class LambdaNotifierElasticBeanstalkHealth
extends LambdaSnsNotifier {
    @Override
    public LambdaSnsNotifier.Processor createProcessor(ObjectMapper om, Logger logger, Notifier notifier, Context context, SnsRecord record) {
        return new ElasticBeanstalkProcessor(om, logger, notifier, context, record);
    }

    public class ElasticBeanstalkProcessor
    extends LambdaSnsNotifier.Processor {
        public ElasticBeanstalkProcessor(ObjectMapper om, Logger logger, Notifier notifier, Context context, SnsRecord record) {
            super(LambdaNotifierElasticBeanstalkHealth.this, om, logger, notifier, context, record, "AWS Elastic Beanstalk");
        }

        @Override
        protected void processPayload() {
            String message = this.record.getSns().getMessage();
            String[] parts = message.split("\n");
            if (parts.length == 0) {
                this.traits.put("Message", message);
                return;
            }
            int unknown = 0;
            for (String source : parts) {
                String key;
                int pos = source.indexOf(": ");
                if (pos < 0) {
                    if (source.length() <= 0) continue;
                    key = "Unknown-" + ++unknown;
                    this.traits.put(key, source);
                    continue;
                }
                key = source.substring(0, pos).replace(" ", "-");
                String value = source.substring(pos + 2);
                if ("Message".equals(key)) {
                    this.summary = value;
                    continue;
                }
                this.traits.put(key, value);
            }
        }

        @Override
        protected void decorateNotification() {
            if (this.summary != null && this.summary.startsWith("Environment health has transitioned from ")) {
                if (this.summary.contains(" to Severe.")) {
                    this.builder.trait("elastic_beanstalk_status", (Object)"severe");
                } else if (this.summary.contains(" to Info.")) {
                    this.builder.trait("elastic_beanstalk_status", (Object)"info");
                } else if (this.summary.contains(" to Ok.")) {
                    this.builder.trait("elastic_beanstalk_status", (Object)"ok");
                } else {
                    this.builder.trait("elastic_beanstalk_status", (Object)"unknown");
                }
            } else {
                this.builder.trait("elastic_beanstalk_status", (Object)"unknown");
            }
        }
    }
}

