/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.lambda.pipeline;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CodePipelineJob {
    private final Job job;

    public CodePipelineJob(@JsonProperty(value="CodePipelineJob") Job job) {
        this.job = job;
    }

    @JsonIgnore
    public String getUserParameters() {
        return this.job.data.actionConfiguration.configuration.userParameters;
    }

    public Job getJob() {
        return this.job;
    }

    public String toString() {
        return String.format("%s { job=%s }", this.getClass().getSimpleName(), this.job);
    }

    public static class ExecutionDetails {
        private final String externalExecutionId;
        private final int percentComplete;
        private final String summary;

        public ExecutionDetails(@JsonProperty(value="externalExecutionId") String externalExecutionId, @JsonProperty(value="percentComplete") int percentComplete, @JsonProperty(value="summary") String summary) {
            this.externalExecutionId = externalExecutionId;
            this.percentComplete = percentComplete;
            this.summary = summary;
        }

        public String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        public int getPercentComplete() {
            return this.percentComplete;
        }

        public String getSummary() {
            return this.summary;
        }
    }

    public static class CurrentRevision {
        private final String changeIdentifier;
        private final int created;
        private final String revision;
        private final String revisionSummary;

        public CurrentRevision(@JsonProperty(value="changeIdentifier") String changeIdentifier, @JsonProperty(value="created") int created, @JsonProperty(value="revision") String revision, @JsonProperty(value="revisionSummary") String revisionSummary) {
            this.changeIdentifier = changeIdentifier;
            this.created = created;
            this.revision = revision;
            this.revisionSummary = revisionSummary;
        }

        public String getChangeIdentifier() {
            return this.changeIdentifier;
        }

        public int getCreated() {
            return this.created;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getRevisionSummary() {
            return this.revisionSummary;
        }
    }

    public static class Response {
        private final String continuationToken;
        private final String jobId;
        private final CurrentRevision currentRevision;
        private final ExecutionDetails executionDetails;

        public Response(@JsonProperty(value="jobId") String jobId) {
            this.continuationToken = null;
            this.jobId = jobId;
            this.currentRevision = null;
            this.executionDetails = null;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public String getJobId() {
            return this.jobId;
        }

        public CurrentRevision getCurrentRevision() {
            return this.currentRevision;
        }

        public ExecutionDetails getExecutionDetails() {
            return this.executionDetails;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration {
        private final String functionName;
        private final String userParameters;

        public Configuration(@JsonProperty(value="FunctionName") String functionName, @JsonProperty(value="UserParameters") String userParameters) {
            this.functionName = functionName;
            this.userParameters = userParameters;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getUserParameters() {
            return this.userParameters;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ActionConfiguration {
        private final Configuration configuration;

        public ActionConfiguration(@JsonProperty(value="configuration") Configuration configuration) {
            this.configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Data {
        private final ActionConfiguration actionConfiguration;

        public Data(@JsonProperty(value="actionConfiguration") ActionConfiguration actionConfiguration) {
            this.actionConfiguration = actionConfiguration;
        }

        public ActionConfiguration getActionConfiguration() {
            return this.actionConfiguration;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Job {
        private final String id;
        private final String accountId;
        private final Data data;

        public Job(@JsonProperty(value="id") String id, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="data") Data data) {
            this.id = id;
            this.accountId = accountId;
            this.data = data;
        }

        public String getId() {
            return this.id;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public Data getData() {
            return this.data;
        }

        public String toString() {
            return String.format("%s {id=%s, accountId=%s}", this.getClass().getSimpleName(), this.id, this.accountId);
        }
    }
}

