/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfo;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.notify.kernel.notification.CreateNotification;
import org.tiogasolutions.notify.pub.AttachmentInfo;
import org.tiogasolutions.notify.pub.ExceptionInfo;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.NotificationRef;

@CouchEntity(value="Notification")
public class NotificationEntity {
    private final String notificationId;
    private String revision;
    private final String domainName;
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final ExceptionInfo exceptionInfo;
    private CouchAttachmentInfoMap attachmentInfoMap;

    public static NotificationEntity newEntity(String domainName, CreateNotification create) {
        return new NotificationEntity(domainName, TimeUuid.randomUUID().toString(), null, create.getTopic(), create.getSummary(), create.getTrackingId(), create.getCreatedAt(), create.getTraitMap(), create.getExceptionInfo());
    }

    @JsonCreator
    public NotificationEntity(@JsonProperty(value="domainName") String domainName, @JsonProperty(value="notificationId") String notificationId, @JsonProperty(value="revision") String revision, @JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="traitMap") Map<String, String> traitMap, @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo) {
        this.domainName = domainName;
        this.notificationId = notificationId;
        this.revision = revision;
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt;
        this.exceptionInfo = exceptionInfo;
        this.traitMap = traitMap != null ? Collections.unmodifiableMap(traitMap) : Collections.emptyMap();
    }

    public NotificationRef toNotificationRef() {
        return new NotificationRef(this.domainName, this.notificationId, this.revision);
    }

    public Notification toNotification() {
        return new Notification(null, this.domainName, this.notificationId, this.revision, this.topic, this.summary, this.trackingId, this.createdAt, this.traitMap, this.exceptionInfo, this.listAttachmentInfo());
    }

    public Notification toNotificationWithRevision(String revisionArg) {
        return new Notification(null, this.domainName, this.notificationId, revisionArg, this.topic, this.summary, this.trackingId, this.createdAt, this.traitMap, this.exceptionInfo, this.listAttachmentInfo());
    }

    @CouchId
    public String getNotificationId() {
        return this.notificationId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<AttachmentInfo> listAttachmentInfo() {
        ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>();
        if (this.attachmentInfoMap != null) {
            for (Map.Entry entry : this.attachmentInfoMap.entrySet()) {
                AttachmentInfo attachInfo = new AttachmentInfo((String)entry.getKey(), ((CouchAttachmentInfo)entry.getValue()).getContentType());
                attachmentInfoList.add(attachInfo);
            }
        }
        return attachmentInfoList;
    }
}

