/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfo;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.notify.kernel.request.LqAttachmentInfo;
import org.tiogasolutions.notify.kernel.request.LqRequestEntityStatus;
import org.tiogasolutions.notify.notifier.LqException;
import org.tiogasolutions.notify.notifier.request.LqExceptionInfo;
import org.tiogasolutions.notify.notifier.request.LqRequest;

@CouchEntity(value="LqRequest")
public class LqRequestEntity {
    private final String requestId;
    private String revision;
    public LqRequestEntityStatus requestStatus;
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final LqExceptionInfo exceptionInfo;
    private CouchAttachmentInfoMap attachmentInfoMap;

    @JsonCreator
    public LqRequestEntity(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="revision") String revision, @JsonProperty(value="requestStatus") LqRequestEntityStatus requestStatus, @JsonProperty(value="topic") String topic, @JsonProperty(value="summary") String summary, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="traitMap") Map<String, String> traitMap, @JsonProperty(value="exceptionInfo") LqExceptionInfo exceptionInfo) {
        this.requestId = requestId;
        this.revision = revision;
        this.requestStatus = requestStatus;
        this.topic = topic;
        this.summary = summary;
        this.trackingId = trackingId;
        this.createdAt = createdAt;
        this.exceptionInfo = exceptionInfo;
        this.traitMap = traitMap != null ? Collections.unmodifiableMap(new LinkedHashMap<String, String>(traitMap)) : Collections.emptyMap();
    }

    public void ready() {
        if (this.requestStatus != LqRequestEntityStatus.SENDING) {
            throw new LqException("Cannot set request to ready, status is " + (Object)((Object)this.requestStatus));
        }
        this.requestStatus = LqRequestEntityStatus.READY;
    }

    public void processing() {
        if (this.requestStatus != LqRequestEntityStatus.READY) {
            throw new LqException("Cannot set request to processing, status is " + (Object)((Object)this.requestStatus));
        }
        this.requestStatus = LqRequestEntityStatus.PROCESSING;
    }

    public void completed() {
        if (this.requestStatus != LqRequestEntityStatus.PROCESSING) {
            throw new LqException("Cannot set request to completed, status is " + (Object)((Object)this.requestStatus));
        }
        this.requestStatus = LqRequestEntityStatus.COMPLETED;
    }

    public void failed() {
        if (this.requestStatus != LqRequestEntityStatus.PROCESSING) {
            throw new LqException("Cannot set request to failed, status is " + (Object)((Object)this.requestStatus));
        }
        this.requestStatus = LqRequestEntityStatus.FAILED;
    }

    public void ready(String currentRevision) {
        if (this.requestStatus != LqRequestEntityStatus.SENDING) {
            throw new LqException("Cannot change status to READY, current status is " + (Object)((Object)this.requestStatus));
        }
        this.requestStatus = LqRequestEntityStatus.READY;
        this.revision = currentRevision;
    }

    @CouchId
    public String getRequestId() {
        return this.requestId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public LqRequestEntityStatus getRequestStatus() {
        return this.requestStatus;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public LqExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<LqAttachmentInfo> listAttachmentInfo() {
        ArrayList<LqAttachmentInfo> attachmentInfoList = new ArrayList<LqAttachmentInfo>();
        if (this.attachmentInfoMap != null) {
            for (Map.Entry entry : this.attachmentInfoMap.entrySet()) {
                LqAttachmentInfo attachInfo = new LqAttachmentInfo((String)entry.getKey(), ((CouchAttachmentInfo)entry.getValue()).getContentType());
                attachmentInfoList.add(attachInfo);
            }
        }
        return attachmentInfoList;
    }

    public LqRequest toRequest() {
        return new LqRequest(this.topic, this.summary, this.trackingId, this.createdAt, this.traitMap, this.exceptionInfo, Collections.emptyList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LqRequestEntity that = (LqRequestEntity)o;
        if (this.createdAt != null ? !this.createdAt.isEqual(that.createdAt) : that.createdAt != null) {
            return false;
        }
        if (this.exceptionInfo != null ? !this.exceptionInfo.equals((Object)that.exceptionInfo) : that.exceptionInfo != null) {
            return false;
        }
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        if (this.requestStatus != that.requestStatus) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.trackingId != null ? !this.trackingId.equals(that.trackingId) : that.trackingId != null) {
            return false;
        }
        return !(this.traitMap != null ? !this.traitMap.equals(that.traitMap) : that.traitMap != null);
    }

    public int hashCode() {
        int result = this.requestId != null ? this.requestId.hashCode() : 0;
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.requestStatus != null ? this.requestStatus.hashCode() : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.trackingId != null ? this.trackingId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.exceptionInfo != null ? this.exceptionInfo.hashCode() : 0);
        result = 31 * result + (this.traitMap != null ? this.traitMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LqRequestEntity{requestId='" + this.requestId + '\'' + ", revision='" + this.revision + '\'' + ", requestStatus=" + (Object)((Object)this.requestStatus) + ", topic='" + this.topic + '\'' + ", summary='" + this.summary + '\'' + ", trackingId='" + this.trackingId + '\'' + ", createdAt=" + this.createdAt + ", exceptionInfo=" + this.exceptionInfo + ", traitMap=" + this.traitMap + '}';
    }

    public static LqRequestEntity newEntity(LqRequest request) {
        return new LqRequestEntity(TimeUuid.randomUUID().toString(), null, LqRequestEntityStatus.SENDING, request.getTopic(), request.getSummary(), request.getTrackingId(), request.getCreatedAt(), request.getTraitMap(), request.getExceptionInfo());
    }
}

