/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.DatatypeConverter;
import org.springframework.util.StringUtils;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.notify.kernel.admin.AdminKernel;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.pub.DomainProfile;

@PreMatching
@Priority(value=1000)
public class LqFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders headers;
    @Context
    Application application;
    @Inject
    private AdminKernel adminKernel;
    @Inject
    private ExecutionManager executionManager;
    @Inject
    private DomainKernel domainKernel;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String baseUri = this.uriInfo.getBaseUri().toString();
        String requestUri = this.uriInfo.getRequestUri().toString();
        String path = requestUri.substring(baseUri.length() - 1);
        Map properties = this.application.getProperties();
        String clientContext = ExceptionUtils.assertNotZeroLength((String)((String)properties.get("app.client.context")), (String)"app.client.context");
        String adminContext = ExceptionUtils.assertNotZeroLength((String)((String)properties.get("app.admin.context")), (String)"app.admin.context");
        if (path.equals(clientContext) || path.startsWith(clientContext + "/")) {
            this.authenticateClientRequest(requestContext);
        } else if (path.equals(adminContext) || path.startsWith(adminContext + "/")) {
            this.authenticateAdminRequest(requestContext);
        } else if (path.startsWith("/app")) {
            this.authenticateAdminRequest(requestContext);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.executionManager.clearContext();
    }

    private void authenticateClientRequest(ContainerRequestContext requestContext) {
        DomainProfile domainProfile;
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null || !authHeader.startsWith("Basic ")) {
            throw new NotAuthorizedException((Object)"Notify", new Object[0]);
        }
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
        String basicAuth = new String(bytes, StandardCharsets.UTF_8);
        int pos = basicAuth.indexOf(":");
        if (pos < 0) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        String apiKey = basicAuth.substring(0, pos);
        String apiPassword = basicAuth.substring(pos + 1);
        if (StringUtils.isEmpty((Object)apiKey) || StringUtils.isEmpty((Object)apiPassword)) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (apiKey.equals("system") && apiPassword.equals("changeme")) {
            domainProfile = this.domainKernel.getSystemDomain();
        } else {
            try {
                domainProfile = this.domainKernel.findByApiKey(apiKey);
            }
            catch (ApiNotFoundException e) {
                throw new NotAuthorizedException((Object)"API", new Object[0]);
            }
            if (EqualsUtils.objectsNotEqual((Object)apiPassword, (Object)domainProfile.getApiPassword())) {
                throw new NotAuthorizedException((Object)"API", new Object[0]);
            }
        }
        if (EqualsUtils.objectsNotEqual((Object)apiPassword, (Object)domainProfile.getApiPassword())) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        SecurityContext securityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext((SecurityContext)new ClientSecurityContext(securityContext, domainProfile));
        this.executionManager.newApiContext(domainProfile, this.uriInfo, this.headers);
    }

    private void authenticateAdminRequest(ContainerRequestContext requestContext) {
        String password;
        String username;
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (!authHeader.startsWith("Basic ")) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
        String basicAuth = new String(bytes, StandardCharsets.UTF_8);
        int pos = basicAuth.indexOf(":");
        if (pos < 0) {
            username = basicAuth;
            password = null;
        } else {
            username = basicAuth.substring(0, pos);
            password = basicAuth.substring(pos + 1);
        }
        this.adminKernel.authorize(username, password);
        SecurityContext securityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext((SecurityContext)new AdminSecurityContext(securityContext, username));
    }

    private class ClientSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final String domainName;
        private final Principal principal;

        public ClientSecurityContext(SecurityContext securityContext, DomainProfile domain) {
            this.secure = securityContext.isSecure();
            this.domainName = domain.getDomainName();
            this.principal = this::getDomainName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "BASIC_AUTH";
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }
    }

    private class AdminSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final String username;

        public AdminSecurityContext(SecurityContext securityContext, String username) {
            this.username = username;
            this.secure = securityContext.isSecure();
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "BASIC_AUTH";
        }

        public Principal getUserPrincipal() {
            return this::getUsername;
        }
    }
}

