/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ExceptionTraceElement {
    private final String className;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;

    @JsonCreator
    public ExceptionTraceElement(@JsonProperty(value="className") String className, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="fileName") String fileName, @JsonProperty(value="lineNumber") int lineNumber) {
        this.className = className;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public ExceptionTraceElement(StackTraceElement element) {
        this.className = element.getClassName();
        this.methodName = element.getMethodName();
        this.fileName = element.getFileName();
        this.lineNumber = element.getLineNumber();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionTraceElement that = (ExceptionTraceElement)o;
        if (this.lineNumber != that.lineNumber) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
            return false;
        }
        return !(this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + this.lineNumber;
        return result;
    }

    public String toString() {
        return String.format("at %s.%s(%s:%s)", this.className, this.methodName, this.fileName, this.lineNumber);
    }
}

