/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class LocalDateTimeSerializer
extends JSR310FormattedSerializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    private LocalDateTimeSerializer() {
        this(null, null);
    }

    private LocalDateTimeSerializer(Boolean useTimestamp, DateTimeFormatter dtf) {
        super(LocalDateTime.class, useTimestamp, dtf);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalDateTime> withFormat(Boolean useTimestamp, DateTimeFormatter dtf) {
        return new LocalDateTimeSerializer(useTimestamp, dtf);
    }

    public void serialize(LocalDateTime dateTime, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            generator.writeStartArray();
            generator.writeNumber(dateTime.getYear());
            generator.writeNumber(dateTime.getMonthValue());
            generator.writeNumber(dateTime.getDayOfMonth());
            generator.writeNumber(dateTime.getHour());
            generator.writeNumber(dateTime.getMinute());
            if (dateTime.getSecond() > 0 || dateTime.getNano() > 0) {
                generator.writeNumber(dateTime.getSecond());
                if (dateTime.getNano() > 0) {
                    if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        generator.writeNumber(dateTime.getNano());
                    } else {
                        generator.writeNumber(dateTime.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            generator.writeEndArray();
        } else {
            String str = this._formatter == null ? dateTime.toString() : dateTime.format(this._formatter);
            generator.writeString(str);
        }
    }
}

