/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.builder;

import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.notify.notifier.builder.LqBuilder;
import org.tiogasolutions.notify.notifier.builder.LqBuilderCallback;

public class LqBuilderCallbacks {
    private final List<LqBuilderCallback> onBeginCallbacks = new ArrayList<LqBuilderCallback>();
    private final List<LqBuilderCallback> beforeSendCallbacks = new ArrayList<LqBuilderCallback>();

    public LqBuilderCallbacks() {
    }

    public LqBuilderCallbacks(LqBuilderCallbacks callbacks) {
        this.onBeginCallbacks.addAll(callbacks.onBeginCallbacks);
        this.beforeSendCallbacks.addAll(callbacks.beforeSendCallbacks);
    }

    public LqBuilderCallbacks copy() {
        return new LqBuilderCallbacks(this);
    }

    public void onBegin(LqBuilderCallback callback) {
        this.onBeginCallbacks.add(callback);
    }

    public void onBeforeSend(LqBuilderCallback callback) {
        this.beforeSendCallbacks.add(callback);
    }

    public void callBegin(LqBuilder builder) {
        this.onBeginCallbacks.stream().forEachOrdered(c -> c.call(builder));
    }

    public void callBeforeSend(LqBuilder builder) {
        this.beforeSendCallbacks.stream().forEachOrdered(c -> c.call(builder));
    }

    protected List<LqBuilderCallback> getOnBeginCallbacks() {
        return this.onBeginCallbacks;
    }

    protected List<LqBuilderCallback> getBeforeSendCallbacks() {
        return this.beforeSendCallbacks;
    }
}

