/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.meta;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.internal.util.ClassUtil;

public class ValueAccessor {
    private final String propertyName;
    private final Method readMethod;
    private final Method writeMethod;
    private final Field field;

    public ValueAccessor(Class<?> type, Method readMethod) {
        this.readMethod = readMethod;
        this.propertyName = Introspector.decapitalize(readMethod.getName().substring(3));
        this.writeMethod = ClassUtil.findSetterMethod(type, this.propertyName, readMethod.getReturnType());
        if (this.writeMethod == null) {
            this.field = ClassUtil.findField(type, this.propertyName);
            if (this.field != null) {
                this.field.setAccessible(true);
            }
        } else {
            this.field = null;
        }
    }

    public ValueAccessor(Field field) {
        this.readMethod = null;
        this.propertyName = field.getName();
        this.writeMethod = null;
        this.field = field;
        this.field.setAccessible(true);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object readValue(Object object) {
        try {
            if (this.readMethod != null) {
                return this.readMethod.invoke(object, new Object[0]);
            }
            if (this.field != null) {
                return this.field.get(object);
            }
            throw CouchException.internalServerError("Cannot read value from " + this.propertyName + ", did not find a corresponding field or getter.");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw CouchException.internalServerError("Error reading value from " + this.propertyName + ", likely an issue with CouchAce id, revision or attachment annotations", e);
        }
    }

    public void writeValue(Object object, Object value) {
        block4: {
            try {
                if (this.writeMethod != null) {
                    this.writeMethod.invoke(object, value);
                    break block4;
                }
                if (this.field != null) {
                    this.field.set(object, value);
                    break block4;
                }
                throw CouchException.internalServerError("Cannot assign value to " + this.propertyName + ", did not find a corresponding field or setter.");
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw CouchException.internalServerError("Error reading value from " + this.propertyName + ", likely an issue with CouchAce id, revision or attachment annotations", e);
            }
        }
    }

    public boolean isWritable() {
        return this.writeMethod != null || this.field != null;
    }

    public boolean isReadable() {
        return this.readMethod != null || this.field != null;
    }
}

