/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.spi.http;

import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.api.http.CouchHttpQuery;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.query.CouchPageQuery;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.request.DeleteAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.DeleteDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.GetAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.GetDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.HeadRequest;
import org.tiogasolutions.couchace.core.api.request.PostDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.PostDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.PostEntityRequest;
import org.tiogasolutions.couchace.core.api.request.PostRequest;
import org.tiogasolutions.couchace.core.api.request.PutAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.PutDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.PutDesignRequest;
import org.tiogasolutions.couchace.core.api.request.PutDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.PutEntityRequest;
import org.tiogasolutions.couchace.core.api.request.PutRequest;
import org.tiogasolutions.couchace.core.api.request.ReadDocumentRequest;
import org.tiogasolutions.couchace.core.internal.util.UriUtil;
import org.tiogasolutions.couchace.core.spi.http.HttpDeleteRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpGetRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpHeadRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpPostRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpPutRequest;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;

public class HttpRequestFactory {
    private final String databaseName;
    private final CouchJsonStrategy jsonStrategy;

    public HttpRequestFactory(String databaseName, CouchJsonStrategy jsonStrategy) {
        this.databaseName = databaseName;
        this.jsonStrategy = jsonStrategy;
    }

    public HttpHeadRequest newHttpHeadRequest(HeadRequest request) {
        PathAndQuery pathAndQuery = this.buildPathAndQuery(request);
        return new HttpHeadRequest(pathAndQuery.path, pathAndQuery.httpQuery, request.getDocumentId());
    }

    public HttpGetRequest newHttpGetRequest(ReadDocumentRequest request) {
        PathAndQuery pathAndQuery = this.buildPathAndQuery(request);
        CouchMediaType acceptType = CouchMediaType.APPLICATION_JSON;
        if (request instanceof GetAttachmentRequest) {
            acceptType = null;
        }
        return new HttpGetRequest(pathAndQuery.path, pathAndQuery.httpQuery, request.getDocumentId(), acceptType);
    }

    public HttpGetRequest newHttpGetRequest(GetDatabaseRequest request) {
        String path = UriUtil.buildPathIgnoreNull(this.databaseName, request.getPath());
        return new HttpGetRequest(path, request.getHttpQuery(), null, request.getContentType());
    }

    protected PathAndQuery buildPathAndQuery(ReadDocumentRequest request) {
        String path;
        CouchHttpQuery.Builder queryBuilder = CouchHttpQuery.Builder();
        if (request instanceof GetAttachmentRequest) {
            GetAttachmentRequest getAttachmentRequest = (GetAttachmentRequest)request;
            path = UriUtil.buildPath(this.databaseName, request.getDocumentId(), getAttachmentRequest.getAttachmentName());
            if (request.getDocumentRevision() != null) {
                queryBuilder.add("rev", request.getDocumentRevision());
            }
        } else if (request.getDocumentId() != null) {
            path = UriUtil.buildPath(this.databaseName, request.getDocumentId());
            if (request.getDocumentRevision() != null) {
                queryBuilder.add("rev", request.getDocumentRevision());
            }
        } else if (request.getViewQuery() != null) {
            CouchViewQuery viewQuery = request.getViewQuery();
            path = UriUtil.buildPath(this.databaseName, "_design", viewQuery.getDesignName(), "_view", viewQuery.getViewName());
            queryBuilder.add("include_docs", String.valueOf(viewQuery.isIncludeDocs()));
            if (viewQuery.hasKey()) {
                queryBuilder.add("key", viewQuery.getKeyJson());
            }
            if (viewQuery.hasStartKey()) {
                queryBuilder.add("startkey", viewQuery.getStartKeyJson());
            }
            if (viewQuery.hasEndKey()) {
                queryBuilder.add("endkey", viewQuery.getEndKeyJson());
            }
            if (viewQuery.getLimit() > 0) {
                queryBuilder.add("limit", String.valueOf(viewQuery.getLimit() + 1));
            }
            if (viewQuery.getSkip() > 0) {
                queryBuilder.add("skip", String.valueOf(viewQuery.getSkip()));
            }
            if (viewQuery.isDescending()) {
                queryBuilder.add("descending", String.valueOf(viewQuery.isDescending()));
            }
        } else if (request.getPageQuery() != null) {
            CouchPageQuery pageQuery = request.getPageQuery();
            path = UriUtil.buildPath(this.databaseName, pageQuery.getRequestedPage());
            queryBuilder.add("include_docs", String.valueOf(pageQuery.isIncludeDocs()));
            queryBuilder.add("limit", String.valueOf(pageQuery.getPageSize() + 1));
        } else {
            throw CouchException.badRequest("ReadRequest did not supply a document id, view query or page query");
        }
        return new PathAndQuery(path, queryBuilder.build());
    }

    public HttpDeleteRequest newHttpDeleteRequest(DeleteDocumentRequest request) {
        if (request.getType() == DeleteDocumentRequest.Type.DATABASE) {
            String path = UriUtil.buildPath(this.databaseName);
            return new HttpDeleteRequest(path);
        }
        String path = UriUtil.buildPath(this.databaseName, request.getDocumentId());
        CouchHttpQuery.Builder builder = CouchHttpQuery.Builder();
        builder.add("rev", request.getDocumentRevision());
        return new HttpDeleteRequest(path, request.getDocumentId(), builder.build());
    }

    public HttpDeleteRequest newHttpDeleteRequest(DeleteAttachmentRequest request) {
        String path = UriUtil.buildPath(this.databaseName, request.getDocumentId(), request.getAttachmentName());
        CouchHttpQuery.Builder builder = CouchHttpQuery.Builder();
        builder.add("rev", request.getDocumentRevision());
        return new HttpDeleteRequest(path, request.getDocumentId(), builder.build());
    }

    public HttpPostRequest newHttpPostRequest(PostRequest request) {
        if (request instanceof PostEntityRequest) {
            return this.newHttpPostEntityRequest((PostEntityRequest)request);
        }
        if (request instanceof PostDocumentRequest) {
            return this.newHttpPostDocumentRequest((PostDocumentRequest)request);
        }
        if (request instanceof PostDatabaseRequest) {
            return this.newHttpPostDatabaseRequest((PostDatabaseRequest)request);
        }
        String className = request == null ? "null" : request.getClass().getName();
        String msg = String.format("The request %s is not supported.", className);
        throw CouchException.badRequest(msg);
    }

    protected HttpPostRequest newHttpPostEntityRequest(PostEntityRequest request) {
        String json = this.jsonStrategy.createJsonForPost(request);
        return new HttpPostRequest(this.databaseName, json);
    }

    protected HttpPostRequest newHttpPostDocumentRequest(PostDocumentRequest request) {
        String json = request.getDocument();
        return new HttpPostRequest(this.databaseName, json);
    }

    protected HttpPostRequest newHttpPostDatabaseRequest(PostDatabaseRequest request) {
        String path = UriUtil.buildPathIgnoreNull(this.databaseName, request.getPath());
        return new HttpPostRequest(path, request.getContent());
    }

    public HttpPutRequest newHttpPutRequest(PutRequest request) {
        if (request instanceof PutEntityRequest) {
            return this.newHttpPutEntityRequest((PutEntityRequest)request);
        }
        if (request instanceof PutDocumentRequest) {
            return this.newHttpPutDocumentRequest((PutDocumentRequest)request);
        }
        if (request instanceof PutAttachmentRequest) {
            return this.newHttpPutAttachmentRequest((PutAttachmentRequest)request);
        }
        if (request instanceof PutDesignRequest) {
            return this.newHttpPutDesignRequest((PutDesignRequest)request);
        }
        if (request instanceof PutDatabaseRequest) {
            return this.newHttpPutDatabaseRequest((PutDatabaseRequest)request);
        }
        String className = request == null ? "null" : request.getClass().getName();
        String msg = String.format("The request %s is not supported.", className);
        throw CouchException.badRequest(msg);
    }

    protected HttpPutRequest newHttpPutEntityRequest(PutEntityRequest request) {
        String json = this.jsonStrategy.createJsonForPut(request);
        CouchHttpQuery.Builder queryBuilder = CouchHttpQuery.Builder();
        if (request.getDocumentRevision() != null) {
            queryBuilder.add("rev", request.getDocumentRevision());
        }
        String path = UriUtil.buildPath(this.databaseName, request.getDocumentId());
        return new HttpPutRequest(path, queryBuilder.build(), request.getDocumentId(), CouchMediaType.APPLICATION_JSON, json);
    }

    protected HttpPutRequest newHttpPutDesignRequest(PutDesignRequest request) {
        String designContent = request.getDesignContent();
        String designName = request.getDesignName();
        CouchHttpQuery.Builder queryBuilder = CouchHttpQuery.Builder();
        if (request.getDocumentRevision() != null) {
            queryBuilder.add("rev", request.getDocumentRevision());
        }
        String path = UriUtil.buildPath(this.databaseName, "_design", designName);
        return new HttpPutRequest(path, queryBuilder.build(), designName, CouchMediaType.APPLICATION_JSON, designContent);
    }

    protected HttpPutRequest newHttpPutDocumentRequest(PutDocumentRequest request) {
        String documentId = request.getDocumentId();
        CouchHttpQuery.Builder queryBuilder = CouchHttpQuery.Builder();
        if (request.getDocumentRevision() != null) {
            queryBuilder.add("rev", request.getDocumentRevision());
        }
        String path = UriUtil.buildPath(this.databaseName, documentId);
        return new HttpPutRequest(path, queryBuilder.build(), documentId, CouchMediaType.APPLICATION_JSON, request.getDocument());
    }

    protected HttpPutRequest newHttpPutDatabaseRequest(PutDatabaseRequest request) {
        String path = UriUtil.buildPathIgnoreNull(this.databaseName, request.getPath());
        return new HttpPutRequest(path, null, null, CouchMediaType.APPLICATION_JSON, request.getContent());
    }

    protected HttpPutRequest newHttpPutAttachmentRequest(PutAttachmentRequest request) {
        String path = UriUtil.buildPath(this.databaseName, request.getDocumentId(), request.getAttachmentName());
        String documentId = request.getDocumentId();
        CouchHttpQuery.Builder queryBuilder = CouchHttpQuery.Builder();
        if (request.getDocumentRevision() != null) {
            queryBuilder.add("rev", request.getDocumentRevision());
        }
        Object content = request.getContent() != null ? request.getContent() : null;
        return new HttpPutRequest(path, queryBuilder.build(), documentId, request.getContentType(), content);
    }

    private static class PathAndQuery {
        private final String path;
        private final CouchHttpQuery httpQuery;

        private PathAndQuery(String path, CouchHttpQuery httpQuery) {
            this.path = path;
            this.httpQuery = httpQuery;
        }
    }
}

