/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.notify.server.grizzly.GrizzlyServer;
import org.tiogasolutions.notify.server.grizzly.GrizzlyServerConfig;
import org.tiogasolutions.notify.server.grizzly.NotifyJaxRsConfig;
import org.tiogasolutions.runners.jersey.support.JerseySpringBridge;
import org.tiogasolutions.runners.jersey.support.ResourceConfigAdapter;

public class NotifyServer {
    private static final Logger log = LoggerFactory.getLogger(NotifyServer.class);

    public static void main(String ... args) {
        Path runtimeDir;
        String runtimeDirArg = EnvUtils.findProperty((String)"notify.runtime_dir");
        if (runtimeDirArg == null) {
            File currentDir = IoUtils.currentDir();
            File moduleDir = IoUtils.findDirNear((File)currentDir, (String)"runtime");
            if (moduleDir == null) {
                throw new RuntimeException("Application runtime directory not specified and could not be found automatically, must be provided with system property notify.runtime_dir.");
            }
            runtimeDirArg = moduleDir.getAbsolutePath();
        }
        if (Files.notExists(runtimeDir = Paths.get(runtimeDirArg, new String[0]).toAbsolutePath(), new LinkOption[0])) {
            throw new RuntimeException("Runtime directory " + runtimeDir + " does not exist");
        }
        if (!Files.isDirectory(runtimeDir, new LinkOption[0])) {
            throw new RuntimeException("Runtime directory " + runtimeDir + " is not a directory");
        }
        System.out.println("Runtime dir: " + runtimeDir);
        System.setProperty("notify.runtime_dir", runtimeDir.toString());
        Path configDir = runtimeDir.resolve("config");
        if (Files.notExists(configDir, new LinkOption[0])) {
            throw new RuntimeException("Config directory " + configDir + " does not exist");
        }
        if (!Files.isDirectory(runtimeDir, new LinkOption[0])) {
            throw new RuntimeException("Config directory " + configDir + " is not a directory");
        }
        System.out.println("Config dir: " + configDir);
        System.setProperty("notify.runtime_dir", runtimeDir.toString());
        String logConfigArg = EnvUtils.findProperty((String)"notify.log_config", (String)"logback.xml");
        Path logConfigFile = configDir.resolve(logConfigArg);
        System.out.println("Configure logging from: " + logConfigFile.toString());
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logConfigFile.toString());
        }
        catch (JoranException je) {
            je.printStackTrace();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        String activeProfiles = System.getProperty("spring.profiles.active");
        activeProfiles = activeProfiles != null ? activeProfiles + ",hosted" : "hosted";
        System.setProperty("spring.profiles.active", activeProfiles);
        log.info("Active spring profiles: " + activeProfiles);
        String springFileName = EnvUtils.findProperty((String)"notify.spring_config", (String)"spring-config.xml");
        Path springConfig = configDir.resolve(springFileName);
        String springConfigPath = springConfig.toUri().toString();
        NotifyJaxRsConfig jaxRsConfig = new NotifyJaxRsConfig(activeProfiles, springConfigPath);
        ResourceConfigAdapter adapter = new ResourceConfigAdapter((Application)jaxRsConfig);
        adapter.register((Object)new JerseySpringBridge(jaxRsConfig.getBeanFactory(), new Object[0]));
        GrizzlyServerConfig serverConfig = (GrizzlyServerConfig)jaxRsConfig.getBeanFactory().getBean(GrizzlyServerConfig.class);
        GrizzlyServer grizzlyServer = new GrizzlyServer(serverConfig);
        grizzlyServer.start((ResourceConfig)adapter);
    }
}

