/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.request;

import java.util.List;
import javax.inject.Inject;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.response.CouchResponse;
import org.tiogasolutions.couchace.core.api.response.GetAttachmentResponse;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.notify.kernel.request.LqAttachmentHolder;
import org.tiogasolutions.notify.kernel.request.LqRequestCouchView;
import org.tiogasolutions.notify.kernel.request.LqRequestEntity;
import org.tiogasolutions.notify.kernel.request.LqRequestEntityStatus;
import org.tiogasolutions.notify.notifier.LqException;
import org.tiogasolutions.notify.notifier.request.LqAttachment;

public class LqRequestStore {
    private final CouchDatabase couchDatabase;

    @Inject
    public LqRequestStore(CouchDatabase couchDatabase) {
        this.couchDatabase = couchDatabase;
    }

    public CouchDatabase getCouchDatabase() {
        return this.couchDatabase;
    }

    public WriteResponse save(LqRequestEntity requestEntity) {
        return this.couchDatabase.put().entity((Object)requestEntity).execute();
    }

    public LqRequestEntity saveAndReload(LqRequestEntity requestEntity) {
        this.couchDatabase.put().entity((Object)requestEntity).onError(r -> this.throwError(r, "Error saving LqRequest by request id " + requestEntity.getRequestId())).execute();
        return this.findByRequestId(requestEntity.getRequestId());
    }

    public WriteResponse addAttachment(String documentId, String revision, LqAttachment attachment) {
        CouchMediaType mediaType = CouchMediaType.fromString((String)attachment.getContentType());
        return this.couchDatabase.put().attachment(documentId, revision, attachment.getName(), mediaType, (Object)attachment.getInputStream()).onError(r -> this.throwError(r, String.format("Failure storing notification attachment in couch [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
    }

    public LqAttachmentHolder findAttachment(String requestId, String attachmentName) {
        GetAttachmentResponse attachmentResponse = this.couchDatabase.get().attachment(requestId, attachmentName).onError(r -> this.throwError(r, "Error finding LqRequest by request id " + requestId)).onResponse(r -> this.throwIfNotFound((GetAttachmentResponse)r, "LqRequest not found by request id " + requestId)).execute();
        byte[] content = attachmentResponse.getContent() instanceof byte[] ? (byte[])attachmentResponse.getContent() : attachmentResponse.getStringContent().getBytes();
        return new LqAttachmentHolder(attachmentName, attachmentResponse.getContentType().getMediaString(), content);
    }

    public LqRequestEntity findByRequestId(String requestId) {
        GetEntityResponse getResponse = this.couchDatabase.get().entity(LqRequestEntity.class, requestId).onError(r -> this.throwError(r, "Error finding LqRequest by request id " + requestId)).onResponse(r -> this.throwIfNotFound((GetEntityResponse)r, "LqRequest not found by request id " + requestId)).execute();
        return (LqRequestEntity)getResponse.getFirstEntity();
    }

    public LqRequestEntity findByTrackingId(String trackingId) {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"LqRequest", (String)LqRequestCouchView.ByTrackingId.name()).key(new Object[]{trackingId}).build();
        GetEntityResponse getResponse = this.couchDatabase.get().entity(LqRequestEntity.class, viewQuery).onError(r -> this.throwError(r, "Error finding LqRequest by tracking id " + trackingId)).onResponse(r -> this.throwIfNotFound((GetEntityResponse)r, "LqRequest not found by tracking id " + trackingId)).execute();
        return (LqRequestEntity)getResponse.getFirstEntity();
    }

    public List<LqRequestEntity> findByStatus(LqRequestEntityStatus status) {
        CouchViewQuery.CouchViewQueryBuilder builder = CouchViewQuery.builder((String)"LqRequest", (String)LqRequestCouchView.ByRequestStatusAndCreatedAt.name());
        if (status != null) {
            builder.start(new Object[]{status, null});
            builder.end(new Object[]{status, "Z"});
        }
        CouchViewQuery viewQuery = builder.build();
        GetEntityResponse getResponse = this.couchDatabase.get().entity(LqRequestEntity.class, viewQuery).onError(r -> this.throwError(r, "Error finding " + (Object)((Object)status) + " requests")).execute();
        return getResponse.getEntityList();
    }

    public void deleteRequest(String requestId) {
        if (requestId == null) {
            throw new NullPointerException("The value \"requestId\" cannot be null.");
        }
        LqRequestEntity request = this.findByRequestId(requestId);
        this.couchDatabase.delete().document(request.getRequestId(), request.getRevision()).onError(r -> this.throwError(r, String.format("Error deleting %s with id %s", LqRequestEntity.class, request.getRequestId()))).execute();
    }

    private void throwError(CouchResponse response, String message) {
        String msg = String.format("%s: %s", message, response.getErrorReason());
        throw new LqException(msg);
    }

    private void throwIfNotFound(GetEntityResponse response, String message) {
        if (response.isEmpty() || response.isNotFound()) {
            throw new LqException(message);
        }
    }

    private void throwIfNotFound(GetAttachmentResponse response, String message) {
        if (response.isEmpty() || response.isNotFound()) {
            throw new LqException(message);
        }
    }
}

