/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.tiogasolutions.couchace.core.api.injectable.MissingInjectableResponse;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaRepository;
import org.tiogasolutions.couchace.jackson.internal.CouchJacksonModule;
import org.tiogasolutions.couchace.jackson.internal.CouchJacksonSerializerIntrospector;
import org.tiogasolutions.couchace.jackson.internal.CustomJacksonInjectableValues;

public class CouchJacksonMapper
extends ObjectMapper {
    private final CouchMetaRepository metaRepository;

    public CouchJacksonMapper(ObjectMapper objectMapper, CouchMetaRepository metaRepository) {
        super(objectMapper);
        this.metaRepository = metaRepository;
        this.init(new CustomJacksonInjectableValues(MissingInjectableResponse.RETURN_NULL), metaRepository, Collections.emptyList());
    }

    public CouchJacksonMapper(CouchMetaRepository metaRepository, Module ... modules) {
        this.metaRepository = metaRepository;
        this.init(new CustomJacksonInjectableValues(MissingInjectableResponse.RETURN_NULL), metaRepository, Arrays.asList(modules));
    }

    public CouchJacksonMapper(CouchMetaRepository metaRepository, Collection<Module> modules) {
        this.metaRepository = metaRepository;
        this.init(new CustomJacksonInjectableValues(MissingInjectableResponse.RETURN_NULL), metaRepository, modules);
    }

    protected void init(InjectableValues injectableValues, CouchMetaRepository metaRepository, Collection<Module> modules) {
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.registerModule((Module)new CouchJacksonModule());
        modules.forEach(arg_0 -> ((CouchJacksonMapper)this).registerModule(arg_0));
        this.setInjectableValues(injectableValues);
        CouchJacksonSerializerIntrospector serializerIntrospector = new CouchJacksonSerializerIntrospector(metaRepository);
        this.setAnnotationIntrospectors((AnnotationIntrospector)serializerIntrospector, (AnnotationIntrospector)new JacksonAnnotationIntrospector());
    }

    public void noErrorOnUnknownFilter() {
        this.setFilters((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(CouchJacksonMapper.class);
        return new CouchJacksonMapper(this, this.metaRepository);
    }
}

