/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.tiogasolutions.notify.kernel.EventBus;
import org.tiogasolutions.notify.kernel.notification.NotificationDomain;
import org.tiogasolutions.notify.kernel.task.CreateTask;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.NotificationRef;
import org.tiogasolutions.notify.pub.route.Destination;

@Named
public class TaskGenerator {
    private final EventBus eventBus;
    private final ExecutorService executorService;

    @Inject
    public TaskGenerator(EventBus eventBus) {
        this.eventBus = eventBus;
        this.executorService = Executors.newCachedThreadPool();
    }

    @PreDestroy
    public void dispose() {
        this.executorService.shutdown();
    }

    public Future<List<TaskEntity>> generateTasks(NotificationDomain notificationDomain, Notification notification) {
        Callable<List> taskCreatorCallable = () -> {
            ArrayList<TaskEntity> tasks = new ArrayList<TaskEntity>();
            NotificationRef notificationRef = notification.toNotificationRef();
            Set<Destination> destinations = notificationDomain.findDestinations(notification);
            for (Destination destination : destinations) {
                CreateTask create = CreateTask.create(notificationRef, destination);
                TaskEntity task = notificationDomain.createTask(create, notification);
                tasks.add(task);
            }
            return tasks;
        };
        return this.executorService.submit(taskCreatorCallable);
    }
}

