/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardConversionService
implements IStandardConversionService {
    protected AbstractStandardConversionService() {
    }

    @Override
    public final <T> T convert(Configuration configuration, IProcessingContext processingContext, Object object, Class<T> targetClass) {
        Validate.notNull(targetClass, "Target class cannot be null");
        if (targetClass.equals(String.class)) {
            if (object == null || object instanceof String) {
                return (T)object;
            }
            return (T)this.convertToString(configuration, processingContext, object);
        }
        return this.convertOther(configuration, processingContext, object, targetClass);
    }

    protected String convertToString(Configuration configuration, IProcessingContext processingContext, Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    protected <T> T convertOther(Configuration configuration, IProcessingContext processingContext, Object object, Class<T> targetClass) {
        throw new IllegalArgumentException("No available conversion for target class \"" + targetClass.getName() + "\"");
    }
}

