/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.uuid;

import java.io.Closeable;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import org.tiogasolutions.notify.notifier.uuid.TimeUuidHexUtil;

final class TimeUuidFactory {
    private static AtomicLong lastTime = new AtomicLong(Long.MIN_VALUE);
    private static String macAddress = null;
    private static long clockSeqAndNode = Long.MIN_VALUE;

    TimeUuidFactory() {
    }

    private static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public static long getClockSeqAndNode() {
        return clockSeqAndNode;
    }

    public static long newTime() {
        return TimeUuidFactory.createTime(System.currentTimeMillis());
    }

    public static long createTime(long currentTimeMillis) {
        long timeMillis;
        block2: {
            long current;
            timeMillis = currentTimeMillis * 10000L + 122192928000000000L;
            while (true) {
                if (timeMillis > (current = lastTime.get())) {
                    if (!lastTime.compareAndSet(current, timeMillis)) continue;
                    break block2;
                }
                if (lastTime.compareAndSet(current, current + 1L)) break;
            }
            timeMillis = current + 1L;
        }
        long time = timeMillis << 32;
        time |= (timeMillis & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeMillis >> 48 & 0xFFFL;
    }

    public static String getMACAddress() {
        return macAddress;
    }

    public static String getHardwareAddress() {
        String out;
        block3: {
            out = null;
            try {
                Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                if (ifs == null) break block3;
                while (ifs.hasMoreElements()) {
                    NetworkInterface iface = ifs.nextElement();
                    byte[] hardware = iface.getHardwareAddress();
                    if (hardware == null || hardware.length != 6 || hardware[1] == -1) continue;
                    out = TimeUuidHexUtil.append((Appendable)new StringBuilder(36), hardware).toString();
                    break;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return out;
    }

    static {
        macAddress = TimeUuidFactory.getHardwareAddress();
        clockSeqAndNode |= TimeUuidHexUtil.parseLong(macAddress);
        clockSeqAndNode |= (long)(Math.random() * 16383.0) << 48;
    }
}

