/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.execution;

import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionAccessor;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.pub.DomainProfile;

@Named
public class ExecutionManager
implements ExecutionAccessor {
    private final DomainKernel domainKernel;
    private final ThreadLocal<ExecutionContext> threadLocal = new ThreadLocal();

    @Inject
    public ExecutionManager(DomainKernel domainKernel) {
        this.domainKernel = domainKernel;
    }

    public void clearContext() {
        this.threadLocal.remove();
    }

    public ExecutionContext newSystemContext() {
        ExecutionContext context = new ExecutionContext(this.domainKernel.getSystemDomain());
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newSystemContext(UriInfo uriInfo, HttpHeaders httpHeaders) {
        ExecutionContext context = new ExecutionContext(this.domainKernel.getSystemDomain(), uriInfo, httpHeaders);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(String apiKey, UriInfo uriInfo, HttpHeaders httpHeaders) {
        DomainProfile domainProfile = this.domainKernel.findByApiKey(apiKey);
        ExecutionContext context = new ExecutionContext(domainProfile, uriInfo, httpHeaders);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(DomainProfile domainProfile, UriInfo uriInfo, HttpHeaders httpHeaders) {
        ExecutionContext context = new ExecutionContext(domainProfile, uriInfo, httpHeaders);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(String apiKey) {
        DomainProfile domainProfile = this.domainKernel.findByApiKey(apiKey);
        ExecutionContext context = new ExecutionContext(domainProfile);
        this.assignContext(context);
        return context;
    }

    public ExecutionContext newApiContext(DomainProfile domainProfile) {
        ExecutionContext context = new ExecutionContext(domainProfile);
        this.assignContext(context);
        return context;
    }

    public void assignContext(ExecutionContext context) {
        this.threadLocal.set(context);
    }

    @Override
    public boolean hasContext() {
        return this.threadLocal.get() != null;
    }

    @Override
    public ExecutionContext context() {
        ExecutionContext context = this.threadLocal.get();
        if (context == null) {
            throw ApiException.internalServerError((String)"There is no current execution context for this thread.", (String[])new String[0]);
        }
        return context;
    }

    @Override
    public String domainName() {
        return this.context().getDomainName();
    }
}

