/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.annotations.CouchEmbeddedAttachment;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchEntityId;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.api.meta.CouchEmbeddedAttachmentMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchEntityMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaBuilder;
import org.tiogasolutions.couchace.core.api.meta.ValueAccessor;
import org.tiogasolutions.couchace.core.internal.util.ClassUtil;
import org.tiogasolutions.couchace.core.internal.util.StringUtil;

public class AnnotationCouchMetaBuilder
implements CouchMetaBuilder {
    @Override
    public <T> CouchEntityMeta<T> buildEntityMeta(Class<T> entityClass) {
        ArrayList<CouchEmbeddedAttachmentMeta> localEmbeddedAttachmentList = new ArrayList<CouchEmbeddedAttachmentMeta>();
        CouchEntity couchEntity = ClassUtil.findClassAnnotation(entityClass, CouchEntity.class);
        if (couchEntity == null) {
            throw CouchException.internalServerError("Class " + entityClass.getName() + " does not have required @CouchEntity annotation.");
        }
        String entityType = StringUtil.isNotBlank(couchEntity.value()) ? couchEntity.value() : entityClass.getSimpleName();
        ValueAccessor localIdAccessor = null;
        ValueAccessor localRevisionAccessor = null;
        ValueAccessor localAttachmentsMetaMapAccessor = null;
        String localIdPattern = null;
        for (Method readMethod : ClassUtil.listGetterMethods(entityClass)) {
            CouchId couchId;
            CouchRevision couchRevision;
            if (readMethod == null) continue;
            CouchEmbeddedAttachment couchAttachment = readMethod.getAnnotation(CouchEmbeddedAttachment.class);
            if (couchAttachment != null) {
                ValueAccessor attachmentAccessor = new ValueAccessor(entityClass, readMethod);
                localEmbeddedAttachmentList.add(new CouchEmbeddedAttachmentMeta(couchAttachment, attachmentAccessor));
            }
            if (localRevisionAccessor == null && (couchRevision = readMethod.getAnnotation(CouchRevision.class)) != null) {
                localRevisionAccessor = new ValueAccessor(entityClass, readMethod);
            }
            if (localIdAccessor == null && (couchId = readMethod.getAnnotation(CouchId.class)) != null) {
                localIdAccessor = new ValueAccessor(entityClass, readMethod);
            }
            if (localIdAccessor != null || (couchId = readMethod.getAnnotation(CouchEntityId.class)) == null) continue;
            localIdAccessor = new ValueAccessor(entityClass, readMethod);
            localIdPattern = StringUtil.isNotBlank(couchId.value()) ? couchId.value() : null;
        }
        for (Field field : ClassUtil.listAllFields(entityClass)) {
            if (!CouchAttachmentInfoMap.class.isAssignableFrom(field.getType())) continue;
            localAttachmentsMetaMapAccessor = new ValueAccessor(field);
        }
        if (localIdAccessor == null) {
            throw CouchException.internalServerError("Class " + entityClass.getName() + " does not have required @CouchId annotation.");
        }
        return new CouchEntityMeta<T>(entityClass.getName(), entityClass, entityType, localIdAccessor, localIdPattern, localRevisionAccessor, localAttachmentsMetaMapAccessor, localEmbeddedAttachmentList);
    }
}

