/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.net.URI;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.GetResponse;

public class GetContentResponse
extends GetResponse {
    private final Object content;

    public static GetContentResponse withError(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, CouchErrorContent errorContent) {
        return new GetContentResponse(uri, statusCode, contentType, null, errorContent);
    }

    public static GetContentResponse withContent(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Object content) {
        return new GetContentResponse(uri, statusCode, contentType, content, null);
    }

    public GetContentResponse(URI uri, CouchHttpStatus statusCode, CouchMediaType contentType, Object content, CouchErrorContent errorContent) {
        super(uri, statusCode, contentType, errorContent);
        this.content = content;
    }

    public Object getContent() {
        return this.content;
    }

    public String getStringContent() {
        return this.content != null ? this.content.toString() : null;
    }

    @Override
    public CouchErrorContent getErrorContent() {
        return CouchErrorContent.parseJson(this.getStringContent());
    }

    @Override
    public String getErrorReason() {
        return this.getErrorContent().getReason();
    }

    public boolean isEmpty() {
        if (this.content == null) {
            return true;
        }
        if (this.content instanceof String) {
            return ((String)this.content).isEmpty();
        }
        return false;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

