/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.pub.lqnotify;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.push.pub.lqnotify.LqStackTraceElement;

public final class LqExceptionInfo {
    private final String exceptionType;
    private final String message;
    private final List<LqStackTraceElement> stackTrace;
    private final LqExceptionInfo cause;

    private LqExceptionInfo(@JsonProperty(value="exceptionType") String exceptionType, @JsonProperty(value="message") String message, @JsonProperty(value="stackTrace") List<LqStackTraceElement> stackTrace, @JsonProperty(value="cause") LqExceptionInfo cause) {
        this.exceptionType = exceptionType != null ? exceptionType : "undefined";
        this.message = message != null ? message : "none";
        this.stackTrace = stackTrace != null ? Collections.unmodifiableList(stackTrace) : Collections.emptyList();
        this.cause = cause;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getMessage() {
        return this.message;
    }

    public List<LqStackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public LqExceptionInfo getCause() {
        return this.cause;
    }

    public static LqExceptionInfo create(Throwable t) {
        String exceptionType = t.getClass().getName();
        String message = t.getMessage();
        ArrayList<LqStackTraceElement> stackTraces = new ArrayList<LqStackTraceElement>();
        for (StackTraceElement element : t.getStackTrace()) {
            stackTraces.add(new LqStackTraceElement(element));
        }
        LqExceptionInfo cause = null;
        if (t.getCause() != null) {
            cause = LqExceptionInfo.create(t.getCause());
        }
        return new LqExceptionInfo(exceptionType, message, stackTraces, cause);
    }
}

