/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.tiogasolutions.dev.jackson.TiogaJacksonInjectable;
import org.tiogasolutions.dev.jackson.TiogaJacksonInjectableValues;
import org.tiogasolutions.dev.jackson.TiogaJacksonModule;

public class TiogaJacksonObjectMapper
extends ObjectMapper {
    private final Collection<? extends Module> modules;
    private final Collection<? extends TiogaJacksonInjectable> injectables;

    public static Collection<? extends Module> defaultModules() {
        return Arrays.asList(new TiogaJacksonModule());
    }

    public TiogaJacksonObjectMapper() {
        this(TiogaJacksonObjectMapper.defaultModules(), Collections.emptyList());
    }

    public TiogaJacksonObjectMapper(Collection<? extends TiogaJacksonInjectable> injectables) {
        this(TiogaJacksonObjectMapper.defaultModules(), injectables);
    }

    public TiogaJacksonObjectMapper(Collection<? extends Module> modules, Collection<? extends TiogaJacksonInjectable> injectables) {
        this.modules = modules;
        this.injectables = injectables;
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, false);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        for (Module module : modules) {
            this.registerModule(module);
        }
        TiogaJacksonInjectableValues injectableValues = new TiogaJacksonInjectableValues();
        for (TiogaJacksonInjectable tiogaJacksonInjectable : injectables) {
            injectableValues.addValue(tiogaJacksonInjectable.getKey(), tiogaJacksonInjectable.getValue());
        }
        this.setInjectableValues((InjectableValues)injectableValues);
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(TiogaJacksonObjectMapper.class);
        return new TiogaJacksonObjectMapper(this.getModules(), this.getInjectables());
    }

    public Collection<? extends Module> getModules() {
        return Collections.unmodifiableCollection(this.modules);
    }

    public Collection<? extends TiogaJacksonInjectable> getInjectables() {
        return Collections.unmodifiableCollection(this.injectables);
    }
}

