/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.thymeleaf.exceptions.AlreadyInitializedException;
import org.thymeleaf.util.PatternUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternSpec {
    private final LinkedHashSet<String> patternStrs = new LinkedHashSet(3);
    private final LinkedHashSet<Pattern> patterns = new LinkedHashSet(3);
    private volatile boolean initialized;

    private boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            this.initialized = true;
        }
    }

    private void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Cannot modify template resolver when it has already been initialized");
        }
    }

    public Set<String> getPatterns() {
        return Collections.unmodifiableSet(this.patternStrs);
    }

    public void setPatterns(Set<String> newPatterns) {
        this.checkNotInitialized();
        if (newPatterns != null) {
            this.patternStrs.addAll(newPatterns);
            for (String pattern : newPatterns) {
                this.patterns.add(PatternUtils.strPatternToPattern(pattern));
            }
        }
    }

    public void addPattern(String pattern) {
        this.checkNotInitialized();
        Validate.notEmpty(pattern, "Pattern cannot be null or empty");
        this.patternStrs.add(pattern);
        this.patterns.add(PatternUtils.strPatternToPattern(pattern));
    }

    public void clearPatterns() {
        this.checkNotInitialized();
        this.patternStrs.clear();
        this.patterns.clear();
    }

    public boolean matches(String templateName) {
        for (Pattern p : this.patterns) {
            if (!p.matcher(templateName).matches()) continue;
            return true;
        }
        return false;
    }
}

