/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.BooleanTokenExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.GenericTokenExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LinkExpression;
import org.thymeleaf.standard.expression.MessageExpression;
import org.thymeleaf.standard.expression.NullTokenExpression;
import org.thymeleaf.standard.expression.NumberTokenExpression;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.standard.expression.VariableExpression;

public abstract class SimpleExpression
extends Expression {
    private static final long serialVersionUID = 9145380484247069725L;
    static final char EXPRESSION_START_CHAR = '{';
    static final char EXPRESSION_END_CHAR = '}';

    protected SimpleExpression() {
    }

    static Object executeSimple(Configuration configuration, IProcessingContext processingContext, SimpleExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator, StandardExpressionExecutionContext expContext) {
        if (expression instanceof VariableExpression) {
            return VariableExpression.executeVariable(configuration, processingContext, (VariableExpression)expression, expressionEvaluator, expContext);
        }
        if (expression instanceof MessageExpression) {
            return MessageExpression.executeMessage(configuration, processingContext, (MessageExpression)expression, expContext);
        }
        if (expression instanceof TextLiteralExpression) {
            return TextLiteralExpression.executeTextLiteral(processingContext, (TextLiteralExpression)expression, expContext);
        }
        if (expression instanceof NumberTokenExpression) {
            return NumberTokenExpression.executeNumberToken(processingContext, (NumberTokenExpression)expression, expContext);
        }
        if (expression instanceof BooleanTokenExpression) {
            return BooleanTokenExpression.executeBooleanToken(processingContext, (BooleanTokenExpression)expression, expContext);
        }
        if (expression instanceof NullTokenExpression) {
            return NullTokenExpression.executeNullToken(processingContext, (NullTokenExpression)expression, expContext);
        }
        if (expression instanceof LinkExpression) {
            return LinkExpression.executeLink(configuration, processingContext, (LinkExpression)expression, expContext);
        }
        if (expression instanceof SelectionVariableExpression) {
            return SelectionVariableExpression.executeSelectionVariable(configuration, processingContext, (SelectionVariableExpression)expression, expressionEvaluator, expContext);
        }
        if (expression instanceof GenericTokenExpression) {
            return GenericTokenExpression.executeGenericToken(processingContext, (GenericTokenExpression)expression, expContext);
        }
        throw new TemplateProcessingException("Unrecognized simple expression: " + expression.getClass().getName());
    }
}

