/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.dev.common.ReflectUtils;

public class ComparisonResults {
    public static Type SIZE = Type.SIZE;
    public static Type NOT_EQUAL = Type.NOT_EQUAL;
    public static Type MISSING_A = Type.MISSING_A;
    public static Type MISSING_B = Type.MISSING_B;
    public static Type VALUE_A_IS_NULL = Type.VALUE_A_IS_NULL;
    public static Type VALUE_B_IS_NULL = Type.VALUE_B_IS_NULL;
    public static Type CLASSES_DIFFERENT = Type.CLASSES_DIFFERENT;
    private final List<Result> results;
    private final Map<String, Result> validationMap = new HashMap<String, Result>();

    public ComparisonResults(List<Result> results) {
        this.results = Collections.unmodifiableList(new ArrayList<Result>(results));
        this.validationMap.putAll(this.toMap());
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.results.isEmpty();
    }

    public List<Result> toList() {
        return new ArrayList<Result>(this.results);
    }

    public Map<String, Result> toMap() {
        HashMap<String, Result> map = new HashMap<String, Result>();
        for (Result result : this.results) {
            map.put(result.getBeanName(), result);
        }
        return map;
    }

    public int getCount() {
        return this.results.size();
    }

    public int getValidatableCount() {
        return this.validationMap.size();
    }

    public Result get(int index) {
        return this.results.get(index);
    }

    public void ignore(String ... beanNames) {
        this.ignore(Arrays.asList(beanNames));
    }

    public void ignore(Collection<String> beanNames) {
        for (String beanName : beanNames) {
            this.validationMap.remove(beanName);
        }
    }

    public void assertError(String beanName, Type type, Object valueA, Object valueB) throws ComparisonException {
        Result result = this.assertError(beanName, type);
        if (BeanUtils.objectsNotEqual(valueA, result.getValueA())) {
            String expectedName = ReflectUtils.getName(valueA);
            String actualName = ReflectUtils.getName(result.getValueA());
            String msg = String.format("Value A is not \"%s\" (%s) as expected but rather \"%s\" (%s).", valueA, expectedName, result.getValueA(), actualName);
            throw new ComparisonException(msg);
        }
        if (BeanUtils.objectsNotEqual(valueB, result.getValueB())) {
            String expectedName = ReflectUtils.getName(valueB);
            String actualName = ReflectUtils.getName(result.getValueB());
            String msg = String.format("Value B is not \"%s\" (%s) as expected but rather \"%s\" (%s).", valueB, expectedName, result.getValueB(), actualName);
            throw new ComparisonException(msg);
        }
    }

    public Result assertError(String beanName, Type type) throws ComparisonException {
        if (!this.validationMap.containsKey(beanName)) {
            String msg = String.format("An error for the property \"%s\" does not exist: %s", beanName, this.validationMap.keySet());
            throw new ComparisonException(msg);
        }
        Result result = this.validationMap.remove(beanName);
        if (result.getType() != type) {
            String msg = String.format("The error %s does not exist for the property \"%s\", found %s.", new Object[]{type, beanName, result.getType()});
            throw new ComparisonException(msg);
        }
        return result;
    }

    public void assertValidationComplete() throws ComparisonException {
        if (!this.validationMap.isEmpty()) {
            String msg = String.format("Validation is not complete, %s errors remaining: %s", this.validationMap.size(), this.validationMap.keySet());
            throw new ComparisonException(msg);
        }
    }

    public static class ComparisonException
    extends Exception {
        public ComparisonException(String message) {
            super(message);
        }
    }

    public static class Result {
        private final String beanName;
        private final Object valueA;
        private final Object valueB;
        private final Type type;

        private Result(String beanName, Object valueA, Object valueB, Type type) {
            this.beanName = beanName;
            this.valueA = valueA;
            this.valueB = valueB;
            this.type = type;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Object getValueA() {
            return this.valueA;
        }

        public Object getValueB() {
            return this.valueB;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static class Builder {
        private final List<Result> results = new ArrayList<Result>();

        public Builder add(String beanName, Object valueA, Object valueB, Type type) {
            this.results.add(new Result(beanName, valueA, valueB, type));
            return this;
        }

        public ComparisonResults build() {
            return new ComparisonResults(this.results);
        }
    }

    private static enum Type {
        SIZE,
        NOT_EQUAL,
        MISSING_A,
        MISSING_B,
        VALUE_A_IS_NULL,
        VALUE_B_IS_NULL,
        CLASSES_DIFFERENT;

    }
}

