/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Named;
import org.tiogasolutions.notify.kernel.RequestEventListener;
import org.tiogasolutions.notify.kernel.TaskEventListener;
import org.tiogasolutions.notify.kernel.request.LqRequestEntity;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.Notification;

@Named
public class EventBus {
    private List<TaskEventListener> taskEventListeners = new CopyOnWriteArrayList<TaskEventListener>();
    private List<RequestEventListener> requestEventListener = new CopyOnWriteArrayList<RequestEventListener>();

    private EventBus() {
    }

    public void subscribe(TaskEventListener listener) {
        this.taskEventListeners.add(listener);
    }

    public void subscribe(RequestEventListener listener) {
        this.requestEventListener.add(listener);
    }

    public void taskCreated(String domainName, TaskEntity task, Notification notification) {
        this.taskEventListeners.forEach(listener -> listener.taskCreated(domainName, task, notification));
    }

    public void requestCreated(String domainName, LqRequestEntity request) {
        this.requestEventListener.forEach(listener -> listener.requestCreated(domainName, request));
    }
}

