/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tiogasolutions.couchace.core.api.request.CouchFeature;

public class CouchFeatureSet {
    private static final CouchFeatureSet EMPTY = new CouchFeatureSet(null);
    private final Map<CouchFeature, Object> featureMap;

    public static CouchFeatureSetBuilder builder() {
        return new CouchFeatureSetBuilder();
    }

    public static CouchFeatureSet empty() {
        return EMPTY;
    }

    public CouchFeatureSet(Map<CouchFeature, ?> featureMap) {
        this.featureMap = featureMap != null ? Collections.unmodifiableMap(featureMap) : Collections.emptyMap();
    }

    public boolean containsFeature(CouchFeature feature) {
        return this.featureMap.containsKey((Object)feature);
    }

    public Object getValue(CouchFeature feature) {
        return this.featureMap.get((Object)feature);
    }

    public String getString(CouchFeature feature) {
        Object value = this.featureMap.get((Object)feature);
        return value != null ? value.toString() : null;
    }

    public Boolean getBoolean(CouchFeature feature) {
        Object value = this.featureMap.get((Object)feature);
        return value != null && value instanceof Boolean ? (Boolean)value : null;
    }

    public boolean isTrue(CouchFeature feature) {
        Boolean val = this.getBoolean(feature);
        return val != null && val != false;
    }

    public boolean isValue(CouchFeature feature, Object value) {
        Object val = this.getValue(feature);
        if (value == null) {
            return val == null;
        }
        return value.equals(val);
    }

    public Map<CouchFeature, Object> getFeatureMap() {
        return this.featureMap;
    }

    public static class CouchFeatureSetBuilder {
        private final Map<CouchFeature, Object> featureMap = new HashMap<CouchFeature, Object>();

        public CouchFeatureSetBuilder add(CouchFeature feature, Object value) {
            this.featureMap.put(feature, value);
            return this;
        }

        public CouchFeatureSet build() {
            return new CouchFeatureSet(this.featureMap);
        }
    }
}

