/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils {
    public static Object[] toArray(Object target) {
        return ArrayUtils.toArray(null, target);
    }

    public static Object[] toStringArray(Object target) {
        return ArrayUtils.toArray(String.class, target);
    }

    public static Object[] toIntegerArray(Object target) {
        return ArrayUtils.toArray(Integer.class, target);
    }

    public static Object[] toLongArray(Object target) {
        return ArrayUtils.toArray(Long.class, target);
    }

    public static Object[] toDoubleArray(Object target) {
        return ArrayUtils.toArray(Double.class, target);
    }

    public static Object[] toFloatArray(Object target) {
        return ArrayUtils.toArray(Float.class, target);
    }

    public static Object[] toBooleanArray(Object target) {
        return ArrayUtils.toArray(Boolean.class, target);
    }

    public static int length(Object[] target) {
        Validate.notNull(target, "Cannot get array length of null");
        return target.length;
    }

    public static boolean isEmpty(Object[] target) {
        return target == null || target.length <= 0;
    }

    public static boolean contains(Object[] target, Object element) {
        Validate.notNull(target, "Cannot execute array contains: target is null");
        for (Object targetElement : target) {
            if (!(targetElement == null ? element == null : element != null && targetElement.equals(element))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Object[] target, Object[] elements) {
        Validate.notNull(target, "Cannot execute array containsAll: target is null");
        Validate.notNull(elements, "Cannot execute array containsAll: elements is null");
        return ArrayUtils.containsAll(target, Arrays.asList(elements));
    }

    public static boolean containsAll(Object[] target, Collection<?> elements) {
        Validate.notNull(target, "Cannot execute array contains: target is null");
        Validate.notNull(elements, "Cannot execute array containsAll: elements is null");
        HashSet<Object> remainingElements = new HashSet<Object>(elements);
        remainingElements.removeAll(Arrays.asList(target));
        return remainingElements.isEmpty();
    }

    private static Object[] toArray(Class<?> componentClass, Object target) {
        Validate.notNull(target, "Cannot convert null to array");
        if (target.getClass().isArray()) {
            if (componentClass == null) {
                return (Object[])target;
            }
            Class<?> targetComponentClass = target.getClass().getComponentType();
            if (componentClass.isAssignableFrom(targetComponentClass)) {
                return (Object[])target;
            }
            throw new IllegalArgumentException("Cannot convert object of class \"" + targetComponentClass.getName() + "[]\" to an array" + " of " + componentClass.getClass().getSimpleName());
        }
        if (target instanceof Iterable) {
            Class<Object> computedComponentClass = null;
            Iterable iterableTarget = (Iterable)target;
            ArrayList elements = new ArrayList(5);
            for (Object element : iterableTarget) {
                if (componentClass == null && element != null) {
                    if (computedComponentClass == null) {
                        computedComponentClass = element.getClass();
                    } else if (!computedComponentClass.equals(Object.class) && !computedComponentClass.equals(element.getClass())) {
                        computedComponentClass = Object.class;
                    }
                }
                elements.add(element);
            }
            if (computedComponentClass == null) {
                computedComponentClass = componentClass != null ? componentClass : Object.class;
            }
            Object[] result = (Object[])Array.newInstance(computedComponentClass, elements.size());
            return elements.toArray(result);
        }
        throw new IllegalArgumentException("Cannot convert object of class \"" + target.getClass().getName() + "\" to an array" + (componentClass == null ? "" : " of " + componentClass.getClass().getSimpleName()));
    }

    public static <T, X> X[] copyOf(T[] original, int newLength, Class<? extends X[]> newType) {
        Object[] newArray = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, newArray, 0, Math.min(original.length, newLength));
        return newArray;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return ArrayUtils.copyOf(original, newLength, original.getClass());
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException("Cannot copy array range with indexes " + from + " and " + to);
        }
        char[] copy = new char[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private ArrayUtils() {
    }
}

