/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.request;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.notifier.request.LqAttachment;
import org.tiogasolutions.notify.notifier.request.LqExceptionInfo;

public final class LqRequest {
    private final String topic;
    private final String summary;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final LqExceptionInfo exceptionInfo;
    private final Map<String, String> traitMap;
    private final List<LqAttachment> attachments;

    public LqRequest(String topic, String summary, String trackingId, ZonedDateTime createdAt, Map<String, String> traitsArg, LqExceptionInfo exceptionInfo, Collection<LqAttachment> attachmentsArg) {
        this.topic = topic != null ? topic : "none";
        this.summary = summary != null ? summary : "none";
        this.trackingId = trackingId;
        this.exceptionInfo = exceptionInfo;
        this.createdAt = createdAt != null ? createdAt : ZonedDateTime.now();
        LinkedHashMap<String, String> traitMap = new LinkedHashMap<String, String>();
        if (traitsArg != null) {
            traitMap.putAll(traitsArg);
        }
        this.traitMap = Collections.unmodifiableMap(traitMap);
        ArrayList<LqAttachment> attachmentsList = new ArrayList<LqAttachment>();
        if (attachmentsArg != null) {
            attachmentsList.addAll(attachmentsArg);
        }
        this.attachments = Collections.unmodifiableList(attachmentsList);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getSummary() {
        return this.summary;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LqExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public List<LqAttachment> getAttachments() {
        return this.attachments;
    }
}

