/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.domain.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tiogasolutions.dev.domain.query.QueryResult;

public final class ListQueryResult<T>
implements QueryResult<T> {
    private final Class<T> type;
    private final int limit;
    private final int offset;
    private int totalFound;
    private boolean totalExact;
    private final List<T> resultList;

    public static <T> ListQueryResult<T> newEmpty(Class<T> type) {
        return new ListQueryResult<T>(type, 0, 0, 0, true, Collections.emptyList());
    }

    public static <T> ListQueryResult<T> newSingle(Class<T> type, T value) {
        if (value == null) {
            throw new NullPointerException("Null value argument given to newSingle");
        }
        return new ListQueryResult<T>(type, 0, 0, 1, true, Collections.singleton(value));
    }

    public static <T> ListQueryResult<T> newComplete(Class<T> type, Collection<T> results) {
        return new ListQueryResult<T>(type, 0, 0, results.size(), true, results);
    }

    public static <T> ListQueryResult<T> newComplete(Class<T> type, T ... results) {
        return new ListQueryResult<T>(type, 0, 0, results.length, true, Arrays.asList(results));
    }

    public static <T> ListQueryResult<T> newResult(Class<T> type, int limit, int offset, int totalFound, boolean totalExact, Collection<T> results) {
        return new ListQueryResult<T>(type, limit, offset, totalFound, totalExact, results);
    }

    public static <T> ListQueryResult<T> newResult(Class<T> type, int limit, int offset, int totalFound, boolean totalExact, T ... results) {
        return new ListQueryResult<T>(type, limit, offset, totalFound, totalExact, Arrays.asList(results));
    }

    private ListQueryResult(Class<T> type, int limit, int offset, int totalFound, boolean totalExact, Collection<T> results) {
        this.type = type;
        this.limit = limit;
        this.offset = offset;
        this.totalFound = totalFound;
        this.totalExact = totalExact;
        ArrayList<T> localList = new ArrayList<T>(results);
        this.resultList = Collections.unmodifiableList(localList);
    }

    @Override
    public Class<T> getContainsType() {
        return this.type;
    }

    @Override
    public boolean isContainsType(Class<?> type) {
        return this.type.isAssignableFrom(type);
    }

    @Override
    public boolean isEmpty() {
        return this.resultList.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.resultList.isEmpty();
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSize() {
        return this.resultList.size();
    }

    @Override
    public int getTotalFound() {
        return this.totalFound;
    }

    @Override
    public boolean isTotalExact() {
        return this.totalExact;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public T getFirst() {
        return this.resultList.get(0);
    }

    @Override
    public T getLast() {
        return this.resultList.get(this.resultList.size() - 1);
    }

    @Override
    public T getAt(int index) {
        return this.resultList.get(index);
    }

    @Override
    public List<T> getResults() {
        return this.resultList;
    }

    @Override
    public Iterator<T> iterator() {
        return this.resultList.iterator();
    }

    @Override
    public boolean getHasPrevious() {
        return this.offset != 0;
    }

    @Override
    public boolean getHasNext() {
        return this.offset + this.resultList.size() < this.totalFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListQueryResult that = (ListQueryResult)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.totalFound != that.totalFound) {
            return false;
        }
        if (this.resultList.size() != that.resultList.size()) {
            return false;
        }
        if (!this.resultList.equals(that.resultList)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.offset;
        result = 31 * result + this.limit;
        result = 31 * result + this.totalFound;
        result = 31 * result + this.resultList.hashCode();
        return result;
    }

    public String toString() {
        return "ListQueryResult{type=" + this.type + ", limit=" + this.limit + ", offset=" + this.offset + ", totalFound=" + this.totalFound + ", resultList=" + this.resultList + '}';
    }
}

