/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.slack;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.kernel.processor.ProcessorType;
import org.tiogasolutions.notify.kernel.processor.TaskProcessor;
import org.tiogasolutions.notify.kernel.processor.ThymeleafMessageBuilder;
import org.tiogasolutions.notify.processor.slack.SlackMessage;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.Task;
import org.tiogasolutions.notify.pub.TaskResponse;
import org.tiogasolutions.notify.pub.route.ArgValueMap;

public class SlackTaskProcessor
implements TaskProcessor {
    public static final String DEFAULT_TEMPLATE_PATH = "classpath:/lq-processor-slack/default-slack-template.html";
    private final ThymeleafMessageBuilder messageBuilder = new ThymeleafMessageBuilder();
    private static final ProcessorType PROVIDER_TYPE = new ProcessorType("slack");
    private static final Logger log = LoggerFactory.getLogger(SlackTaskProcessor.class);
    private final Client client;

    public SlackTaskProcessor() {
        ClientConfig httpClientConfig = new ClientConfig().register(MultiPartFeature.class);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)httpClientConfig);
        this.client = clientBuilder.build();
    }

    public boolean isReady() {
        return true;
    }

    public void init(BeanFactory beanFactory) {
    }

    public ProcessorType getType() {
        return PROVIDER_TYPE;
    }

    public TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        try {
            ArgValueMap valueMap = task.getDestination().getArgValueMap();
            if (!valueMap.hasArg("slackUrl")) {
                throw ApiException.badRequest((String)"Slack destination does not define a slackUrl argument", (String[])new String[0]);
            }
            String slackUrl = valueMap.asString("slackUrl");
            String templatePath = this.messageBuilder.getTemplatePath(valueMap, "templatePath", DEFAULT_TEMPLATE_PATH);
            String messageText = this.messageBuilder.createMessage(domainProfile, notification, task, templatePath);
            SlackMessage message = new SlackMessage().setText(messageText);
            if (valueMap.hasArg("channel")) {
                message.setChannel(valueMap.asString("channel"));
            }
            if (valueMap.hasArg("userName")) {
                message.setUserName(valueMap.asString("userName"));
            }
            if (valueMap.hasArg("iconEmoji")) {
                message.setIconEmoji(valueMap.asString("iconEmoji"));
            }
            String json = message.toJson();
            Entity entity = Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE);
            Response response = this.client.target(slackUrl).request().post(entity);
            if (response.getStatus() == 200 || response.getStatus() == 201) {
                log.debug("Successfully sent Slack message: {}", (Object)notification.getSummary());
                return TaskResponse.complete((String)"Ok");
            }
            String content = (String)response.readEntity(String.class);
            String msg = String.format("Failure sending Slack message [%s]: %s", response.getStatus(), content);
            log.error(msg);
            log.error("Slack message JSON: " + json);
            return TaskResponse.fail((String)msg);
        }
        catch (Throwable t) {
            log.error("Exception sending Slack message.", t);
            return TaskResponse.fail((String)"Exception sending Slack message.", (Throwable)t);
        }
    }
}

