/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.meta;

import java.util.Collections;
import java.util.List;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.core.api.json.CouchJsonException;
import org.tiogasolutions.couchace.core.api.meta.CouchEmbeddedAttachmentMeta;
import org.tiogasolutions.couchace.core.api.meta.ValueAccessor;

public class CouchEntityMeta<T> {
    private final String metaName;
    private final Class<T> entityClass;
    private final String entityType;
    private final ValueAccessor idValueAccessor;
    private final String idPattern;
    private final ValueAccessor revisionValueAccessor;
    private final ValueAccessor attachmentInfoMapAccessor;
    private final List<CouchEmbeddedAttachmentMeta> embeddedAttachmentMetaList;

    public CouchEntityMeta(String metaName, Class<T> entityClass, String entityType, ValueAccessor idValueAccessor, String idPattern, ValueAccessor revisionValueAccessor, ValueAccessor attachmentInfoMapAccessor, List<CouchEmbeddedAttachmentMeta> embeddedAttachmentMetaList) {
        this.metaName = metaName;
        this.entityClass = entityClass;
        this.entityType = entityType;
        this.idValueAccessor = idValueAccessor;
        this.idPattern = idPattern;
        this.revisionValueAccessor = revisionValueAccessor;
        this.attachmentInfoMapAccessor = attachmentInfoMapAccessor;
        this.embeddedAttachmentMetaList = embeddedAttachmentMetaList != null ? Collections.unmodifiableList(embeddedAttachmentMetaList) : Collections.emptyList();
    }

    public String getMetaName() {
        return this.metaName;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public String getIdName() {
        return this.idValueAccessor != null ? this.idValueAccessor.getPropertyName() : null;
    }

    public String getRevisionName() {
        return this.revisionValueAccessor != null ? this.revisionValueAccessor.getPropertyName() : null;
    }

    public String readDocumentId(Object entity) {
        Object value;
        String documentId = null;
        if (this.idValueAccessor != null && (value = this.idValueAccessor.readValue(entity)) != null) {
            documentId = value.toString();
            if (this.idPattern != null) {
                documentId = String.format(this.idPattern, value);
            }
        }
        return documentId;
    }

    public String readDocumentRevision(Object entity) {
        Object documentRevision = null;
        if (this.revisionValueAccessor != null) {
            documentRevision = this.revisionValueAccessor.readValue(entity);
        }
        return documentRevision != null ? documentRevision.toString() : null;
    }

    public CouchAttachmentInfoMap readAttachmentInfoMap(Object entity) {
        Object value;
        CouchAttachmentInfoMap attachmentInfoMap = null;
        if (this.attachmentInfoMapAccessor != null && (value = this.attachmentInfoMapAccessor.readValue(entity)) != null) {
            attachmentInfoMap = (CouchAttachmentInfoMap)value;
        }
        return attachmentInfoMap;
    }

    public void writeDocumentId(T entity, String id) {
        if (this.idValueAccessor == null || !this.idValueAccessor.isWritable()) {
            throw CouchJsonException.internalServerError("Cannot assign id to entity " + this.entityClass);
        }
        this.idValueAccessor.writeValue(entity, id);
    }

    public void writeDocumentRevision(T entity, String revision) {
        if (this.revisionValueAccessor == null || !this.revisionValueAccessor.isWritable()) {
            throw CouchJsonException.internalServerError("Cannot assign revision to entity " + this.entityClass);
        }
        this.revisionValueAccessor.writeValue(entity, revision);
    }

    public void writeAttachmentInfoMap(T entity, CouchAttachmentInfoMap attachmentInfoMap) {
        if (this.attachmentInfoMapAccessor == null || !this.attachmentInfoMapAccessor.isWritable()) {
            throw CouchJsonException.internalServerError("Cannot assign attachmentInfoMap to entity " + this.entityClass);
        }
        this.attachmentInfoMapAccessor.writeValue(entity, attachmentInfoMap);
    }

    public boolean hasId() {
        return this.idValueAccessor != null;
    }

    public String getIdPattern() {
        return this.idPattern;
    }

    public boolean isIdSet(Object entity) {
        return this.idValueAccessor != null && this.idValueAccessor.readValue(entity) != null;
    }

    public boolean hasRevision() {
        return this.revisionValueAccessor != null;
    }

    public boolean hasAttachmentsMeta() {
        return this.attachmentInfoMapAccessor != null;
    }

    public boolean isRevisionSet(Object entity) {
        return this.revisionValueAccessor != null && this.revisionValueAccessor.readValue(entity) != null;
    }

    public List<CouchEmbeddedAttachmentMeta> getEmbeddedAttachmentMetaList() {
        return this.embeddedAttachmentMetaList;
    }

    public boolean hasEmbeddedAttachments() {
        return !this.embeddedAttachmentMetaList.isEmpty();
    }

    public String getEntityType() {
        return this.entityType;
    }
}

