/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.internal.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.internal.util.FileNameFilter;

public class IOUtil {
    public static File currentDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File findDirNear(File startDir, String dirName) {
        if (dirName.equalsIgnoreCase(startDir.getName())) {
            return startDir;
        }
        List<File> dirs = IOUtil.listDirs(startDir, new FileNameFilter(dirName));
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        dirs = IOUtil.listDirs(startDir.getParentFile(), new FileNameFilter(dirName));
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        return null;
    }

    public static List<File> listDirs(File parentDir, FileFilter ... fileFilters) {
        ArrayList<File> dirList = new ArrayList<File>();
        File[] listFiles = null;
        if (parentDir != null && parentDir.exists()) {
            listFiles = parentDir.listFiles();
        }
        if (listFiles != null) {
            for (File file : listFiles) {
                if (!file.isDirectory()) continue;
                boolean accepted = true;
                for (FileFilter filter : fileFilters) {
                    if (filter.accept(file)) continue;
                    accepted = false;
                    break;
                }
                if (!accepted) continue;
                dirList.add(file);
            }
        }
        return dirList;
    }

    public static String readText(Path path) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes);
        }
        catch (IOException e) {
            throw CouchException.internalServerError(e);
        }
    }

    public static String readText(URI uri) {
        return IOUtil.readText(Paths.get(uri));
    }

    public static String readText(URL url) {
        if (url == null) {
            throw CouchException.badRequest("Null url argument given to readText");
        }
        try {
            return IOUtil.readText(Paths.get(url.toURI()));
        }
        catch (Exception e) {
            throw CouchException.internalServerError(e);
        }
    }
}

