/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.core.v1;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.tiogasolutions.notify.engine.core.v1.NotificationsResourceV1;
import org.tiogasolutions.notify.engine.core.v1.RequestResourceV1;
import org.tiogasolutions.notify.engine.core.v1.RouteCatalogResourceV1;
import org.tiogasolutions.notify.engine.core.v1.SimpleRequestEntryResourceV1;
import org.tiogasolutions.notify.kernel.EventBus;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.pub.DomainProfile;

public class ClientResourceV1 {
    private final EventBus eventBus;
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final NotificationKernel notificationKernel;

    public ClientResourceV1(ExecutionManager executionManager, DomainKernel domainKernel, NotificationKernel notificationKernel, EventBus eventBus) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
        this.notificationKernel = notificationKernel;
    }

    @GET
    @Produces(value={"application/json"})
    public DomainProfile getDefaultPage() {
        String domainName = this.executionManager.context().getDomainName();
        return this.domainKernel.findByDomainName(domainName);
    }

    @Path(value="/notifications")
    public NotificationsResourceV1 getNotificationsResource() {
        return new NotificationsResourceV1(this.executionManager, this.notificationKernel);
    }

    @Path(value="/route-catalog")
    public RouteCatalogResourceV1 getRouteCatalogResource() {
        return new RouteCatalogResourceV1(this.executionManager, this.domainKernel);
    }

    @Path(value="/requests")
    public RequestResourceV1 getRequestResourceV1() {
        return new RequestResourceV1(this.executionManager, this.domainKernel, this.eventBus);
    }

    @Path(value="/simple-request-entry")
    public SimpleRequestEntryResourceV1 getSimpleRequestEntryV1() {
        return new SimpleRequestEntryResourceV1(this.executionManager, this.domainKernel, this.eventBus);
    }
}

