/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.id;

import java.io.Serializable;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.id.IdGenerator;

public class TwoPartIdGenerator
implements IdGenerator,
Serializable {
    private static final int MAX_ATTEMPTS = 10000000;
    private final Object idLock = new Object();
    private final Set<Integer> rememberedRandomSet = new TreeSet<Integer>();
    private final Random random = new Random(System.currentTimeMillis());
    private final String idFormat;
    private final ZoneId zoneId;
    private final ZonedDateTime prefixBegin;
    private final char[] prefixChars;
    private final int prefixLifeInSeconds;
    private final int minPrefixLength;
    private final int suffixLength;
    private final int suffixMaxInt;
    private String currentPrefix;
    private int currentPrefixNumber;
    private String lastId;

    public TwoPartIdGenerator(String idFormat, ZonedDateTime prefixBegin, String prefixChars, int prefixLifeInSeconds, int minPrefixLength, int suffixLength) {
        this.idFormat = idFormat;
        this.prefixBegin = prefixBegin;
        this.zoneId = prefixBegin.getZone();
        this.prefixLifeInSeconds = prefixLifeInSeconds;
        this.prefixChars = prefixChars.toCharArray();
        this.minPrefixLength = minPrefixLength;
        this.suffixLength = suffixLength;
        this.suffixMaxInt = Integer.valueOf(StringUtils.padRight("", suffixLength, '9'));
        this.currentPrefix = "";
    }

    public TwoPartIdGenerator() {
        this("%s-%s", ZonedDateTime.of(2013, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC")), "ABCDFGHJKLMNPQRSTVWXYZ", 20, 5, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String newId() {
        int attempts = 0;
        while (attempts++ < 10000000) {
            int suffixInt;
            String lastPrefix = this.currentPrefix;
            String prefix = this.generatePrefix();
            if (!lastPrefix.equals(prefix)) {
                this.rememberedRandomSet.clear();
            }
            if (this.rememberedRandomSet.contains(suffixInt = this.random.nextInt(this.suffixMaxInt))) continue;
            this.rememberedRandomSet.add(suffixInt);
            String suffix = StringUtils.padRight(String.valueOf(suffixInt), this.suffixLength, '0');
            String sequence = String.format(this.idFormat, prefix, suffix);
            Object object = this.idLock;
            synchronized (object) {
                this.lastId = sequence;
            }
            return sequence;
        }
        throw new RuntimeException("Exceeded number of attempts at generating a sequence.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastId() {
        Object object = this.idLock;
        synchronized (object) {
            return this.lastId;
        }
    }

    private String generatePrefix() {
        Duration duration = Duration.between(this.prefixBegin, ZonedDateTime.now(this.zoneId));
        int newPrefixNumber = (int)duration.getSeconds() / this.prefixLifeInSeconds;
        if (newPrefixNumber == this.currentPrefixNumber) {
            return this.currentPrefix;
        }
        this.currentPrefixNumber = newPrefixNumber;
        int base = this.prefixChars.length;
        StringBuilder prefixSb = new StringBuilder();
        while (newPrefixNumber != 0) {
            int mod = newPrefixNumber % base;
            prefixSb.insert(0, this.prefixChars[mod]);
            newPrefixNumber /= base;
        }
        this.currentPrefix = StringUtils.padLeft(prefixSb.toString(), this.minPrefixLength, this.prefixChars[0]);
        return this.currentPrefix;
    }
}

