/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.server.grizzly;

import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.server.grizzly.GrizzlyServerConfig;

public class GrizzlyServer {
    private static Logger log = LoggerFactory.getLogger(GrizzlyServer.class);
    private static final int socketAcceptTimeoutMilli = 5000;
    private final GrizzlyServerConfig config;
    private HttpServer httpServer;
    private ServerSocket socket;
    private Thread acceptThread;
    private final ReentrantLock handlerLock = new ReentrantLock();

    public GrizzlyServer(GrizzlyServerConfig config) {
        this.config = config;
    }

    public void start(ResourceConfig resourceConfig) {
        try {
            this.startServer(resourceConfig);
            System.out.printf("Application started with WADL available at %sapplication.wadl%n", this.getBaseUri());
            if (this.config.isOpenBrowser()) {
                URI baseUri = this.getBaseUri();
                Desktop.getDesktop().browse(baseUri);
            }
            Thread.currentThread().join();
        }
        catch (Throwable e) {
            log.error("Exception starting server", e);
            e.printStackTrace();
        }
    }

    public void shutdown() {
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(ResourceConfig resourceConfig) throws Exception {
        this.shutdownExisting();
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.config.getBaseUri(), (ResourceConfig)resourceConfig);
        this.lockHandler();
        try {
            if (this.acceptThread != null) {
                throw new IllegalStateException("Socket handler thread is already running.");
            }
            try {
                this.socket = new ServerSocket(this.config.getShutdownPort());
                this.socket.setSoTimeout(5000);
                String msg = String.format("%s is accepting connections on port %s from %s.", this.getClass().getSimpleName(), this.config.getShutdownPort(), this.socket.getInetAddress().getHostAddress());
                System.out.println(msg);
                log.info(msg);
            }
            catch (IOException ex) {
                String msg = String.format("IOException starting server socket, maybe port %s was not available.", this.config.getShutdownPort());
                log.error(msg, (Throwable)ex);
                System.err.println(msg);
                ex.printStackTrace();
            }
            Thread shutdownThread = new Thread(() -> ((HttpServer)this.httpServer).shutdown(), "shutdownHook");
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            Runnable acceptRun = this::socketAcceptLoop;
            this.acceptThread = new Thread(acceptRun);
            this.acceptThread.start();
        }
        finally {
            this.unlockHandler();
        }
    }

    private void shutdownExisting() throws IOException {
        try (Socket localSocket = new Socket(this.config.getServerName(), this.config.getShutdownPort());
             OutputStream outStream = localSocket.getOutputStream();){
            outStream.write("SHUTDOWN".getBytes());
            outStream.flush();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    private void lockHandler() throws TimeoutException, InterruptedException {
        int timeout = 5;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if (!this.handlerLock.tryLock(timeout, timeUnit)) {
            String msg = String.format("Failed to obtain lock within %s %s", new Object[]{timeout, timeUnit});
            throw new TimeoutException(msg);
        }
    }

    private void unlockHandler() {
        this.handlerLock.unlock();
    }

    public URI getBaseUri() {
        return this.config.getBaseUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void socketAcceptLoop() {
        block7: while (!Thread.interrupted()) {
            try {
                Thread.sleep(5L);
                this.lockHandler();
                if (this.acceptThread == null || Thread.interrupted()) {
                    log.info("Looks like SocketHandler has been stopped, terminate our acceptLoop.");
                    System.out.println("Looks like SocketHandler has been stopped, terminate our acceptLoop.");
                    return;
                }
                Socket client = this.socket.accept();
                StringBuilder builder = new StringBuilder();
                InputStream is = client.getInputStream();
                while (true) {
                    int val;
                    if ((val = is.read()) == -1) continue block7;
                    builder.append((char)val);
                    if (!"SHUTDOWN".equals(builder.toString())) continue;
                    log.info("Shutdown command received.");
                    System.out.println("Shutdown command received.");
                    this.httpServer.shutdownNow();
                    System.exit(0);
                }
            }
            catch (SocketTimeoutException | TimeoutException ex) {
            }
            catch (Throwable ex) {
                log.error("Unexpected exception", ex);
                System.out.println("Unexpected exception");
                ex.printStackTrace();
                return;
            }
            finally {
                this.unlockHandler();
            }
        }
    }
}

