/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.builder;

import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.tiogasolutions.notify.notifier.builder.LqBuilderCallback;
import org.tiogasolutions.notify.notifier.builder.LqBuilderCallbacks;
import org.tiogasolutions.notify.notifier.builder.LqTrait;
import org.tiogasolutions.notify.notifier.request.LqAttachment;
import org.tiogasolutions.notify.notifier.request.LqExceptionInfo;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.notifier.request.LqResponse;
import org.tiogasolutions.notify.notifier.sender.LqSender;

public class LqBuilder {
    private final LqSender sender;
    private final LqBuilderCallbacks callbacks;
    private String topic;
    private String trackingId;
    private String summary;
    private ZonedDateTime createdAt;
    private LqExceptionInfo exceptionInfo;
    private List<LqTrait> traits = new ArrayList<LqTrait>();
    private List<LqAttachment> attachments = new ArrayList<LqAttachment>();

    public LqBuilder(LqSender sender, LqBuilderCallbacks callbacks) {
        this.sender = sender;
        this.callbacks = callbacks.copy();
        callbacks.callBegin(this);
    }

    public LqBuilder onBegin(LqBuilderCallback callback) {
        this.callbacks.onBegin(callback);
        return this;
    }

    public LqBuilder onBeforeSend(LqBuilderCallback callback) {
        this.callbacks.onBeforeSend(callback);
        return this;
    }

    public Future<LqResponse> send() {
        this.callbacks.callBeforeSend(this);
        LqRequest request = new LqRequest(this.topic, this.summary, this.trackingId, this.createdAt, LqTrait.toTraitMap(this.traits), this.exceptionInfo, this.attachments);
        return this.sender.send(request);
    }

    public LqBuilder topic(String topic) {
        this.topic = topic;
        return this;
    }

    public LqBuilder trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    public LqBuilder summary(String summary) {
        this.summary = summary;
        return this;
    }

    public LqBuilder summary(String format, Object ... args) {
        this.summary = String.format(format, args);
        return this;
    }

    public LqBuilder createdAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public LqBuilder trait(String name, Object value) {
        String str = value != null ? value.toString() : null;
        this.traits.add(new LqTrait(name, str));
        return this;
    }

    public LqBuilder traits(String ... traits) {
        this.traits.addAll(LqTrait.toTraits(Arrays.asList(traits)));
        return this;
    }

    public LqBuilder traits(Map<String, String> traitMap) {
        this.traits.addAll(LqTrait.toTraits(traitMap));
        return this;
    }

    public LqBuilder exception(Throwable exception) {
        this.exceptionInfo = new LqExceptionInfo(exception);
        return this;
    }

    public LqBuilder attach(String name, String contentType, byte[] content) {
        this.attachments.add(new LqAttachment(name, contentType, content));
        return this;
    }

    public LqBuilder attach(String name, String contentType, InputStream inputStream) {
        this.attachments.add(new LqAttachment(name, contentType, inputStream));
        return this;
    }

    public LqBuilder attach(String name, String contentType, String content) {
        this.attachments.add(new LqAttachment(name, contentType, content));
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getSummary() {
        return this.summary;
    }

    public LqExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public List<LqTrait> getTraits() {
        return this.traits;
    }

    public List<LqAttachment> getAttachments() {
        return this.attachments;
    }
}

